<?php
declare(strict_types=1);

final class Passwords
{
    public static function validatePolicy(string $pw): array
    {
        $errors = [];
        if (strlen($pw) < 10) $errors[] = 'La contraseña debe tener al menos 10 caracteres.';
        if (!preg_match('/[A-Z]/', $pw)) $errors[] = 'Debe incluir al menos una mayúscula.';
        if (!preg_match('/[a-z]/', $pw)) $errors[] = 'Debe incluir al menos una minúscula.';
        if (!preg_match('/[0-9]/', $pw)) $errors[] = 'Debe incluir al menos un número.';
        return $errors;
    }

    public static function hash(string $pw): string
    {
        $hash = password_hash($pw, PASSWORD_ARGON2ID);
        if (!$hash) throw new RuntimeException('No se pudo hashear la contraseña.');
        return $hash;
    }

    public static function verify(string $pw, string $hash): bool
    {
        return password_verify($pw, $hash);
    }
}
