<?php
declare(strict_types=1);

final class RequireModuleMiddleware
{
    public function __construct(
        private array $config,
        private Logger $logger,
        private string $moduleCode
    ) {}

    public function handle(Request $req, callable $next): Response
    {
        $uid = AuthService::currentUserId();
        if (!$uid) {
            $to = base_path() . '/login?r=' . urlencode($req->path);
            return Response::html(
                '<meta http-equiv="refresh" content="0;url=' . htmlspecialchars($to) . '">',
                302
            )->header('Location', $to);
        }

        if (!ModuleService::isEnabled($uid, $this->moduleCode)) {
            $this->logger->security('Módulo no habilitado', [
                'uid' => $uid,
                'module' => $this->moduleCode,
                'path' => $req->path,
                'ip' => $req->ip,
            ]);

            // 403 HTML por defecto (si luego quieres JSON, lo hacemos por Accept header)
            $html = "<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
            <title>403</title>
            <style>body{font-family:system-ui;background:#0b1220;color:#fff;padding:24px} .card{max-width:860px;background:#101a33;border:1px solid #1e2a52;border-radius:14px;padding:18px}</style>
            </head><body><div class='card'><h2>Acceso restringido</h2><p>No tienes el módulo habilitado para acceder a esta sección.</p></div></body></html>";

            return Response::html($html, 403);
        }

        return $next($req);
    }
}
