<?php
declare(strict_types=1);

final class RequirePermissionMiddleware
{
    public function __construct(
        private array $config,
        private Logger $logger,
        private string $permissionCode
    ) {}

    public function handle(Request $req, callable $next): Response
    {
        $uid = AuthService::currentUserId();
        if (!$uid) {
            $to = base_path() . '/login?r=' . urlencode($req->path);
            return Response::html(
                '<meta http-equiv="refresh" content="0;url=' . htmlspecialchars($to) . '">',
                302
            )->header('Location', $to);
        }

        if (!AuthService::hasPermission($uid, $this->permissionCode)) {
            $this->logger->security('Permiso denegado', [
                'uid' => $uid,
                'perm' => $this->permissionCode,
                'path' => $req->path,
                'ip' => $req->ip,
            ]);

            return Response::html('<h1>403</h1><p>Permiso denegado.</p>', 403);
        }

        return $next($req);
    }
}
