<?php
declare(strict_types=1);

final class CsrfToken
{
    private const SESSION_KEY = '__csrf';

    public static function issue(): string
    {
        $token = bin2hex(random_bytes(32));
        $_SESSION[self::SESSION_KEY] = [
            'token' => $token,
            'ts' => time(),
        ];
        return $token;
    }

    public static function verify(string $token): bool
    {
        $row = $_SESSION[self::SESSION_KEY] ?? null;
        if (!$row || empty($row['token']) || empty($row['ts'])) {
            return false;
        }

        $ttl = (int)($GLOBALS['APP_CONFIG']['security']['csrf']['ttl_seconds'] ?? 1800);
        if ((time() - (int)$row['ts']) > $ttl) {
            unset($_SESSION[self::SESSION_KEY]);
            return false;
        }

        $ok = hash_equals((string)$row['token'], $token);
        // 1 solo uso (rotación)
        unset($_SESSION[self::SESSION_KEY]);
        return $ok;
    }
}
