<?php
declare(strict_types=1);

final class Logger
{
    private string $dir;

    public function __construct(string $logsDir)
    {
        $this->dir = $logsDir;
        if (!is_dir($this->dir)) {
            @mkdir($this->dir, 0755, true);
        }
    }

    public function error(string $message, array $context = []): void
    {
        $this->write('errors.log', $message, $context);
    }

    public function app(string $message, array $context = []): void
    {
        $this->write('app.log', $message, $context);
    }

    public function security(string $message, array $context = []): void
    {
        $this->write('security.log', $message, $context);
    }

    public function audit(string $message, array $context = []): void
    {
        $this->write('audit.log', $message, $context);
    }

    private function write(string $file, string $message, array $context): void
    {
        $line = json_encode([
            'ts' => date('c'),
            'message' => $message,
            'context' => $context,
        ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

        @file_put_contents($this->dir . '/' . $file, $line . PHP_EOL, FILE_APPEND | LOCK_EX);
    }
}
