<?php declare(strict_types=1);
/** @var string|null $error */
/** @var array $old */
$bp = base_path();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Crear módulo</h3>
  <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/modules') ?>">Volver</a>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body">
    <form method="post" action="<?= htmlspecialchars($bp . '/admin/modules/create') ?>" class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Code</label>
        <input class="form-control" name="code" value="<?= htmlspecialchars((string)($old['code'] ?? '')) ?>"
               placeholder="ej: admin_panel, jobs, billing.pro" required>
        <div class="form-text">Minúsculas, números, _ o .</div>
      </div>

      <div class="col-md-6">
        <label class="form-label">Nombre</label>
        <input class="form-control" name="nombre" value="<?= htmlspecialchars((string)($old['nombre'] ?? '')) ?>"
               placeholder="Panel administrativo" required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Estado</label>
        <select class="form-select" name="estado">
          <option value="activo" <?= (($old['estado'] ?? 'activo')==='activo'?'selected':'') ?>>Activo</option>
          <option value="inactivo" <?= (($old['estado'] ?? 'activo')==='inactivo'?'selected':'') ?>>Inactivo</option>
        </select>
      </div>

      <div class="col-12">
        <button class="btn btn-primary" type="submit">Guardar</button>
        <a class="btn btn-light" href="<?= htmlspecialchars($bp . '/admin/modules') ?>">Cancelar</a>
      </div>
    </form>
  </div>
</div>
