<?php
declare(strict_types=1);
/** @var int|null $userId */
$bp = base_path();
?>
<div class="container">

  <!-- Search / actions row -->
  <div class="row g-3 align-items-stretch mb-3" id="buscar">
    <div class="col-12 col-lg-8">
      <div class="app-card p-3">
        <div class="d-flex gap-2">
          <input class="form-control" placeholder="Buscar vacantes, empresas, habilidades..." aria-label="Buscar">
          <button class="btn btn-primary" type="button">Buscar</button>
        </div>
        <div class="small app-muted mt-2">Optimizado para velocidad, anti abuso y SEO (fase siguiente).</div>
      </div>
    </div>
    <div class="col-12 col-lg-4">
      <div class="app-card p-3 h-100">
        <div class="fw-semibold mb-1">Tu sesión</div>
        <div class="small app-muted">Usuario ID: <?= htmlspecialchars((string)$userId) ?></div>
        <div class="small app-muted">Estado: autenticado</div>
      </div>
    </div>
  </div>

  <!-- 3-column feed -->
  <div class="row g-3">
    <!-- Left column -->
    <div class="col-12 col-lg-3">
      <div class="app-card p-3">
        <div class="fw-semibold mb-2">Filtros</div>
        <div class="d-grid gap-2">
          <button class="btn btn-outline-primary btn-sm">Vacantes verificadas</button>
          <button class="btn btn-outline-primary btn-sm">Empresas</button>
          <button class="btn btn-outline-primary btn-sm">Postulantes</button>
          <button class="btn btn-outline-primary btn-sm">Cerca de mí</button>
        </div>
        <hr>
        <div class="small app-muted">Aquí iremos conectando módulos por plan/rol en Fase 2.</div>
      </div>
    </div>

    <!-- Center column -->
    <div class="col-12 col-lg-6" id="publicar">
      <div class="app-card p-3 mb-3">
        <div class="fw-semibold mb-2">Publicar</div>
        <textarea class="form-control" rows="3" placeholder="Comparte una vacante, una actualización o una búsqueda..."></textarea>
        <div class="d-flex justify-content-between align-items-center mt-2">
          <div class="small app-muted">Imágenes (fase siguiente) con compresión y seguridad.</div>
          <button class="btn btn-primary btn-sm" type="button">Publicar</button>
        </div>
      </div>

      <!-- Feed items (mock) -->
      <?php for ($i=1; $i<=6; $i++): ?>
        <div class="app-card p-3 mb-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <div class="fw-semibold">Publicación #<?= $i ?></div>
              <div class="small app-muted">Empresa verificada • hace <?= $i * 7 ?> min</div>
            </div>
            <span class="badge text-bg-light" style="border:1px solid #e8eefc;">Vacante</span>
          </div>

          <div class="mt-2">
            <div class="mb-2">
              Buscamos <strong>Asistente Administrativo</strong> (San José). Experiencia básica, buen manejo de Excel.
            </div>
            <div class="rounded-3 p-3" style="background:#f1f5ff;border:1px dashed #cfe0ff;">
              Área de imagen (Fase 2): aquí irá la imagen optimizada (WebP/AVIF), sin GIF.
            </div>
          </div>

          <div class="d-flex gap-2 mt-3">
            <button class="btn btn-outline-primary btn-sm">Me interesa</button>
            <button class="btn btn-outline-primary btn-sm">Guardar</button>
            <button class="btn btn-outline-secondary btn-sm">Compartir</button>
          </div>
        </div>
      <?php endfor; ?>
    </div>

    <!-- Right column -->
    <div class="col-12 col-lg-3" id="alertas">
      <div class="app-card p-3 mb-3">
        <div class="fw-semibold mb-2">Anuncios (no invasivos)</div>
        <div class="small app-muted">
          En Fase 3 colocaremos franjas por categoría (empleo/postulantes/ofertas), con límites y rate control.
        </div>
      </div>

      <div class="app-card p-3" id="perfil">
        <div class="fw-semibold mb-2">Perfil (placeholder)</div>
        <div class="small app-muted">En Fase 2 agregamos perfil completo, roles, módulos y panel admin.</div>
      </div>
    </div>
  </div>

</div>
