<?php
declare(strict_types=1);

$bp = base_path();
?>

<section class="py-5 bg-light border-bottom">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-7">
        <h1 class="display-5 fw-bold mb-3">Red Laboral Segura</h1>
        <p class="lead text-secondary mb-4">
          Vacantes verificadas, perfiles reales y una experiencia rápida en cualquier dispositivo.
          Seguridad primero: anti-bots, CSRF, rate-limit y buenas prácticas desde el núcleo.
        </p>

        <div class="d-flex flex-wrap gap-2">
          <a class="btn btn-primary btn-lg" href="<?= htmlspecialchars($bp . '/registro') ?>">
            Crear cuenta
          </a>
          <a class="btn btn-outline-primary btn-lg" href="<?= htmlspecialchars($bp . '/login') ?>">
            Iniciar sesión
          </a>
        </div>

        <div class="mt-4 d-flex flex-wrap gap-2">
          <span class="badge bg-white text-dark border">CSRF</span>
          <span class="badge bg-white text-dark border">Rate limit</span>
          <span class="badge bg-white text-dark border">Captcha propio</span>
          <span class="badge bg-white text-dark border">PHP 8.3</span>
          <span class="badge bg-white text-dark border">Bootstrap 5</span>
        </div>
      </div>

      <div class="col-lg-5">
        <div class="p-4 rounded-4 bg-white border shadow-sm">
          <div class="d-flex align-items-center justify-content-between mb-3">
            <div class="fw-semibold">Vista rápida</div>
            <span class="text-secondary small">Ultra rápido</span>
          </div>

          <div class="rounded-4 p-3 mb-3" style="background:#f4f7ff;border:1px dashed #cfe0ff;">
            <div class="fw-semibold mb-1">Feed tipo red social</div>
            <div class="text-secondary small">
              3 columnas en desktop, experiencia tipo app en móvil con navegación inferior.
            </div>
          </div>

          <div class="row g-2">
            <div class="col-6">
              <div class="rounded-4 p-3 border bg-light">
                <div class="fw-semibold">Empresas</div>
                <div class="text-secondary small">Vacantes verificadas</div>
              </div>
            </div>
            <div class="col-6">
              <div class="rounded-4 p-3 border bg-light">
                <div class="fw-semibold">Postulantes</div>
                <div class="text-secondary small">Perfiles reales</div>
              </div>
            </div>
            <div class="col-12">
              <div class="rounded-4 p-3 border bg-light">
                <div class="fw-semibold">Panel Admin + Roles</div>
                <div class="text-secondary small">
                  Permisos por equipo, módulos por plan, automatización con control manual.
                </div>
              </div>
            </div>
          </div>

          <div class="mt-3 small text-secondary">
            En Fase 2 activamos planes, módulos, RBAC y panel total.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="py-5">
  <div class="container">
    <div class="row g-3">
      <div class="col-12 col-lg-4">
        <div class="p-4 rounded-4 border bg-white h-100">
          <div class="fw-semibold mb-2">Seguridad desde el núcleo</div>
          <div class="text-secondary">
            Protección contra abuso, fuerza bruta y automatización. Logs de seguridad y auditoría.
          </div>
        </div>
      </div>

      <div class="col-12 col-lg-4">
        <div class="p-4 rounded-4 border bg-white h-100">
          <div class="fw-semibold mb-2">Rendimiento real</div>
          <div class="text-secondary">
            Estructura ligera (PHP puro), caché por etapas, assets optimizados y mínimo overhead.
          </div>
        </div>
      </div>

      <div class="col-12 col-lg-4">
        <div class="p-4 rounded-4 border bg-white h-100">
          <div class="fw-semibold mb-2">Escalable por módulos</div>
          <div class="text-secondary">
            Activación por plan/rol, panel de administración total y crecimiento por fases sin rehacer.
          </div>
        </div>
      </div>
    </div>

    <div class="mt-4 text-center text-secondary small">
      © <?= date('Y') ?> Red Laboral Segura — Costa Rica
    </div>
  </div>
</section>
