<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= htmlspecialchars($pageTitle ?? 'Admin') ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <style>
    :root { --sbw: 280px; }
    .admin-shell { min-height: 100vh; }
    .sidebar { width: var(--sbw); }
    .sidebar a.nav-link { border-radius: .6rem; color: #1f2937; }
    .sidebar a.nav-link:hover { background: #f3f4f6; }
    .sidebar a.nav-link.active { background: #0d6efd; color: #fff; }
    .sidebar .section-title {
      font-size: .75rem;
      text-transform: uppercase;
      letter-spacing: .04em;
      color: #6b7280;
      margin: .75rem 0 .35rem;
    }
    .content-wrap { width: calc(100% - var(--sbw)); }
    @media (max-width: 991.98px) {
      .sidebar { width: 100%; position: sticky; top: 0; z-index: 1020; }
      .content-wrap { width: 100%; }
    }
  </style>
</head>

<body class="bg-light">
<?php
  // Usuario (si existe helper)
  $user = null;
  if (function_exists('auth_user')) {
      $user = auth_user();
  }

  // Helpers defensivos para permisos/módulos:
  $can = function (string $perm): bool {
      if (function_exists('can')) return (bool)can($perm);
      if (function_exists('has_permission')) return (bool)has_permission($perm);
      if (function_exists('user_can')) return (bool)user_can($perm);
      return true; // no romper UI si helper no existe
  };

  $hasModule = function (string $moduleCode): bool {
      if (function_exists('has_module')) return (bool)has_module($moduleCode);
      if (function_exists('user_has_module')) return (bool)user_has_module($moduleCode);
      if (function_exists('module_enabled')) return (bool)module_enabled($moduleCode);
      return true;
  };

  // Path actual para "active"
  $uri  = $_SERVER['REQUEST_URI'] ?? '';
  $path = parse_url($uri, PHP_URL_PATH) ?: '';
  $bp   = function_exists('base_path') ? (string)base_path() : '';

  $href = function (string $route) use ($bp): string {
      return htmlspecialchars(rtrim($bp, '/') . $route, ENT_QUOTES, 'UTF-8');
  };

  // Active robusto: compara contra la ruta "full" generada por $href (sin htmlspecialchar)
  $isActive = function (string $routePrefix) use ($path, $bp): bool {
      $full = rtrim($bp, '/') . $routePrefix;
      return $full !== '' && str_starts_with($path, $full);
  };

  // Nombres
  $uName  = is_array($user) ? (string)($user['name'] ?? $user['nombre'] ?? $user['email'] ?? 'Usuario') : 'Usuario';
  $uEmail = is_array($user) ? (string)($user['email'] ?? '') : '';

  /**
   * CORRECCIÓN CLAVE (404):
   * El CRUD existe como /admin/modules (inglés). No /admin/modulos.
   * Mantengo labels en español, pero rutas reales en inglés.
   */
  $routeDashboard = '/admin';
  $routeModules   = '/admin/modules';
  $routePlans     = '/admin/plans';
  $routeRbac      = '/admin/rbac';

  $dashboardActive = $isActive($routeDashboard)
      && !$isActive($routeModules)
      && !$isActive($routePlans)
      && !$isActive($routeRbac);
?>
<div class="d-flex flex-column flex-lg-row admin-shell">

  <!-- SIDEBAR -->
  <aside class="sidebar border-end bg-white">
    <div class="p-3 border-bottom d-flex align-items-center justify-content-between">
      <div class="fw-semibold d-flex align-items-center gap-2">
        <i class="bi bi-shield-lock"></i>
        <span>Admin</span>
      </div>

      <button class="btn btn-sm btn-outline-secondary d-lg-none" type="button"
              data-bs-toggle="collapse" data-bs-target="#adminSidebarNav" aria-expanded="false">
        <i class="bi bi-list"></i>
      </button>
    </div>

    <div class="p-3 border-bottom">
      <div class="d-flex align-items-center gap-2">
        <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
             style="width:38px;height:38px;">
          <i class="bi bi-person"></i>
        </div>
        <div class="min-w-0">
          <div class="fw-semibold text-truncate"><?= htmlspecialchars($uName) ?></div>
          <?php if ($uEmail !== ''): ?>
            <div class="small text-muted text-truncate"><?= htmlspecialchars($uEmail) ?></div>
          <?php else: ?>
            <div class="small text-muted">Panel administrativo</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="collapse d-lg-block" id="adminSidebarNav">
      <nav class="p-3">
        <div class="section-title">General</div>

        <a class="nav-link d-flex align-items-center gap-2 <?= $dashboardActive ? 'active' : '' ?>"
           href="<?= $href($routeDashboard) ?>">
          <i class="bi bi-speedometer2"></i>
          <span>Dashboard</span>
        </a>

        <div class="section-title">Administración</div>

        <?php if ($can('admin.modules.manage') && $hasModule('admin_panel')): ?>
          <a class="nav-link d-flex align-items-center gap-2 <?= $isActive($routeModules) ? 'active' : '' ?>"
             href="<?= $href($routeModules) ?>">
            <i class="bi bi-grid-1x2"></i>
            <span>Módulos</span>
          </a>
        <?php endif; ?>

        <?php if ($can('admin.plans.manage') && $hasModule('admin_panel')): ?>
          <a class="nav-link d-flex align-items-center gap-2 <?= $isActive($routePlans) ? 'active' : '' ?>"
             href="<?= $href($routePlans) ?>">
            <i class="bi bi-box"></i>
            <span>Planes</span>
          </a>
        <?php endif; ?>

        <?php if ($can('admin.rbac.manage') && $hasModule('admin_panel')): ?>
          <a class="nav-link d-flex align-items-center gap-2 <?= $isActive($routeRbac) ? 'active' : '' ?>"
             href="<?= $href($routeRbac) ?>">
            <i class="bi bi-diagram-3"></i>
            <span>RBAC</span>
          </a>
        <?php endif; ?>

        <hr class="my-3">

        <a class="nav-link d-flex align-items-center gap-2 text-danger"
           href="<?= $href('/logout') ?>">
          <i class="bi bi-box-arrow-right"></i>
          <span>Salir</span>
        </a>
      </nav>
    </div>
  </aside>

  <!-- CONTENT -->
  <main class="content-wrap flex-fill">
    <div class="p-3 border-bottom bg-white d-flex justify-content-between align-items-center">
      <div class="fw-semibold"><?= htmlspecialchars($pageTitle ?? 'Admin') ?></div>
      <div class="small text-secondary">Panel administrativo</div>
    </div>

    <div class="p-3">
      <?= $content ?? '' ?>
    </div>
  </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
