<?php
declare(strict_types=1);
/** @var string $pageTitle */
/** @var string $content */
$bp = base_path();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <link rel="icon" href="<?= htmlspecialchars($bp) ?>/assets/img/favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    :root{
      --app-bg:#f6f8ff;
      --card:#ffffff;
      --stroke:#e8eefc;
      --ink:#0b1220;
      --muted:#5b6b86;
      --primary:#245bff;
    }
    body{ background:var(--app-bg); color:var(--ink); }
    .app-topbar{
      position:sticky; top:0; z-index:20;
      background:rgba(255,255,255,0.92);
      backdrop-filter: blur(8px);
      border-bottom:1px solid var(--stroke);
    }
    .app-shell{ padding-top: 14px; padding-bottom: 86px; }
    .app-card{
      background:var(--card);
      border:1px solid var(--stroke);
      border-radius:16px;
    }
    .app-muted{ color:var(--muted); }

    .bottom-nav{
      position:fixed; bottom:0; left:0; right:0; z-index:30;
      background:rgba(255,255,255,0.96);
      backdrop-filter: blur(8px);
      border-top:1px solid var(--stroke);
      padding:10px 14px;
      display:none;
    }
    .bottom-nav a{
      text-decoration:none;
      color:var(--muted);
      font-size:12px;
      display:flex;
      flex-direction:column;
      align-items:center;
      gap:4px;
    }
    .bottom-nav .dot{
      width:44px;height:44px;border-radius:14px;
      background:#f1f5ff;border:1px solid var(--stroke);
      display:flex;align-items:center;justify-content:center;
      color:var(--primary);
      font-weight:700;
    }

    /* Mobile app-like */
    @media (max-width: 992px){
      .bottom-nav{ display:flex; justify-content:space-between; }
    }
  </style>
</head>
<body>

  <div class="app-topbar">
    <div class="container py-3 d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <div class="rounded-3 px-3 py-2" style="background:#eef3ff;border:1px solid var(--stroke);font-weight:700;color:var(--primary);">
          JOB
        </div>
        <div>
          <div class="fw-semibold" style="line-height:1.1;">Red Laboral</div>
          <div class="small app-muted">Feed seguro y rápido</div>
        </div>
      </div>

      <div class="d-flex gap-2">
        <a class="btn btn-outline-primary btn-sm" href="<?= htmlspecialchars($bp) ?>/logout">Salir</a>
      </div>
    </div>
  </div>

  <main class="app-shell">
    <?= $content ?>
  </main>

  <!-- Bottom nav (mobile) -->
  <nav class="bottom-nav">
    <a href="<?= htmlspecialchars($bp) ?>/feed">
      <span class="dot">🏠</span>
      <span>Feed</span>
    </a>
    <a href="<?= htmlspecialchars($bp) ?>/feed#buscar">
      <span class="dot">🔎</span>
      <span>Buscar</span>
    </a>
    <a href="<?= htmlspecialchars($bp) ?>/feed#publicar">
      <span class="dot">＋</span>
      <span>Publicar</span>
    </a>
    <a href="<?= htmlspecialchars($bp) ?>/feed#alertas">
      <span class="dot">🔔</span>
      <span>Alertas</span>
    </a>
    <a href="<?= htmlspecialchars($bp) ?>/feed#perfil">
      <span class="dot">👤</span>
      <span>Perfil</span>
    </a>
  </nav>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
