<?php
declare(strict_types=1);
/** @var string $pageTitle */
/** @var string $content */
$bp = base_path();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="description" content="<?= htmlspecialchars(($GLOBALS['APP_CONFIG']['seo']['default_description'] ?? 'Vacantes verificadas y perfiles reales.')) ?>">
  <meta name="theme-color" content="#245bff">

  <link rel="icon" href="<?= htmlspecialchars($bp) ?>/assets/img/favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    :root{
      --bg:#f6f8ff;
      --card:#ffffff;
      --stroke:#e8eefc;
      --ink:#0b1220;
      --muted:#5b6b86;
      --primary:#245bff;
    }
    body{ background:var(--bg); color:var(--ink); }
    .topbar{
      position:sticky; top:0; z-index:20;
      background:rgba(255,255,255,0.92);
      backdrop-filter: blur(8px);
      border-bottom:1px solid var(--stroke);
    }
    .brand-badge{
      background:#eef3ff;border:1px solid var(--stroke);
      color:var(--primary); font-weight:800;
      border-radius:14px; padding:.55rem .85rem;
      letter-spacing:.4px;
    }
  </style>
</head>
<body>

<header class="topbar">
  <div class="container py-3 d-flex align-items-center justify-content-between">
    <div class="d-flex align-items-center gap-2">
      <div class="brand-badge">JOB</div>
      <div>
        <div class="fw-semibold" style="line-height:1.1;">Red Laboral Segura</div>
        <div class="small text-secondary">Costa Rica</div>
      </div>
    </div>

    <div class="d-flex gap-2">
      <a class="btn btn-outline-primary btn-sm" href="<?= htmlspecialchars($bp . '/login') ?>">Login</a>
      <a class="btn btn-primary btn-sm" href="<?= htmlspecialchars($bp . '/registro') ?>">Registro</a>
    </div>
  </div>
</header>

<main>
  <?= $content ?>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
