<?php
declare(strict_types=1);

/**
 * Layout base seguro:
 * - Evita warnings por variables no definidas
 * - Soporta $pageTitle y $content opcionales
 */

$cfg = $GLOBALS['APP_CONFIG'] ?? [];

$siteName = (string)($cfg['seo']['site_name'] ?? 'Red Laboral Segura');
$baseUrl  = (string)($cfg['app']['base_url'] ?? '');

// Variables que vienen del render_template
$pageTitle = isset($pageTitle) && is_string($pageTitle) && $pageTitle !== '' ? $pageTitle : $siteName;
$content   = isset($content) && is_string($content) ? $content : '';

// SEO básicos
$desc = (string)($cfg['seo']['default_description'] ?? 'Vacantes verificadas y perfiles reales.');
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8') ?></title>
  <meta name="description" content="<?= htmlspecialchars($desc, ENT_QUOTES, 'UTF-8') ?>">

  <!-- Bootstrap 5 (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-white">

  <?= $content ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
