<?php
declare(strict_types=1);

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

echo "<pre>";

echo "PHP: " . PHP_VERSION . PHP_EOL;
echo "DOCROOT: " . ($_SERVER['DOCUMENT_ROOT'] ?? '') . PHP_EOL;

$root = dirname(__DIR__);
echo "ROOT: $root" . PHP_EOL;

$files = [
  $root . '/src/Bootstrap/app.php',
  $root . '/src/Config/config.php',
  $root . '/src/Support/Helpers.php',
  $root . '/src/Support/Exceptions.php',
  $root . '/src/Http/Router.php',
  $root . '/templates/layouts/front.php',
  $root . '/templates/front/index.php',
];

foreach ($files as $f) {
  echo (file_exists($f) ? "OK   " : "MISS ") . $f . PHP_EOL;
}

echo PHP_EOL . "Including app bootstrap..." . PHP_EOL;
require_once $root . '/src/Bootstrap/app.php';

echo "Boot OK" . PHP_EOL;
echo "</pre>";
