<?php
declare(strict_types=1);

final class AdminMenuBuilder
{
    public static function buildForUser(int $userId): array
    {
        $items = [];

        foreach (AdminMenu::items() as $item) {

            // 1. Permiso
            if (!empty($item['permission'])) {
                if (!AuthService::hasPermission($userId, $item['permission'])) {
                    continue;
                }
            }

            // 2. Módulo
            if (!empty($item['module'])) {
                if (!ModuleService::isEnabled($userId, $item['module'])) {
                    continue;
                }
            }

            $items[] = $item;
        }

        return $items;
    }
}
