<?php
// Este archivo se incluye dentro de App::registerRoutes().
// Por lo tanto, $this apunta a la instancia de App y podemos usar $this->mapGet / $this->redirect / $this->gatePostulante.

$this->mapGet('/postulante', function (Request $req): Response {
    return $this->redirect(base_path() . '/postulante/panel', 302);
});

$this->mapGet('/postulante/panel', function (Request $req): Response {
    return $this->gatePostulante($req, function (Request $req): Response {

        $uid = (int)AuthService::currentUserId();

        $pdo = DB::pdo();
        $u = $pdo->prepare("SELECT id,email,nombre,tipo FROM users WHERE id=:id LIMIT 1");
        $u->execute(['id' => $uid]);
        $user = $u->fetch(PDO::FETCH_ASSOC) ?: ['id'=>$uid,'email'=>'','nombre'=>'','tipo'=>'postulante'];

        $perfil = PostulanteProfileService::getOrCreate($uid);
        $cv     = CvService::latestActiveForUser($uid);

        // Categorías seleccionadas (match/segmentación)
        $selectedIds = [];
        try {
            $selectedIds = user_selected_categoria_ids($uid);
        } catch (Throwable $e) {
            $selectedIds = [];
        }

        $selectedCats = [];
        if ($selectedIds) {
            $in = implode(',', array_fill(0, count($selectedIds), '?'));
            $st = $pdo->prepare("SELECT id,nombre,codigo,parent_id FROM categorias_laborales WHERE id IN ($in) ORDER BY nombre ASC");
            foreach ($selectedIds as $i => $cid) {
                $st->bindValue($i+1, (int)$cid, PDO::PARAM_INT);
            }
            $st->execute();
            $selectedCats = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
        }

        // Completitud (100 pts)
        $score = 0;
        $checks = [];

        $hasCats = count($selectedIds) > 0;
        $checks['categorias'] = $hasCats;
        $score += $hasCats ? 25 : 0;

        $hasTitulo = trim((string)($perfil['titulo_profesional'] ?? '')) !== '';
        $checks['titulo_profesional'] = $hasTitulo;
        $score += $hasTitulo ? 15 : 0;

        $hasBio = trim((string)($perfil['bio'] ?? '')) !== '';
        $checks['bio'] = $hasBio;
        $score += $hasBio ? 15 : 0;

        $hasUbic = trim((string)($perfil['ubicacion'] ?? '')) !== '';
        $checks['ubicacion'] = $hasUbic;
        $score += $hasUbic ? 10 : 0;

        $hasTel = trim((string)($perfil['telefono'] ?? '')) !== '';
        $checks['telefono'] = $hasTel;
        $score += $hasTel ? 5 : 0;

        $hasLinkedIn = trim((string)($perfil['linkedin_url'] ?? '')) !== '';
        $checks['linkedin'] = $hasLinkedIn;
        $score += $hasLinkedIn ? 10 : 0;

        $hasPortfolio = trim((string)($perfil['portfolio_url'] ?? '')) !== '';
        $checks['portfolio'] = $hasPortfolio;
        $score += $hasPortfolio ? 5 : 0;

        $hasCv = is_array($cv) && (int)($cv['id'] ?? 0) > 0;
        $checks['cv'] = $hasCv;
        $score += $hasCv ? 15 : 0;

        $completion = max(0, min(100, (int)$score));

        // Recomendaciones (matching) - base para monetización por boosts/ads
        $reco = [];
        try {
            // FeedService::feedForPostulante devuelve ['items'=>..., 'stats'=>...]
            // En el panel solo ocupamos las vacantes recomendadas (items).
            $out = FeedService::feedForPostulante($uid, '', 6, 0, [
                'only_matching' => 1,
                'categoria_ids' => $selectedIds,
            ]);
            $reco = is_array($out) ? ($out['items'] ?? []) : [];
        } catch (Throwable $e) {
            $reco = [];
        }

        $html = render_template('layouts/app.php', [
            'pageTitle' => 'Panel del postulante',
            'content'   => render_template('postulante/panel.php', [
                'user'         => $user,
                'perfil'       => $perfil,
                'cv'           => $cv,
                'selectedCats' => $selectedCats,
                'completion'   => $completion,
                'checks'       => $checks,
                'reco'         => $reco,
            ]),
        ]);

        return Response::html($html, 200);
    });
});
