<?php
declare(strict_types=1);

final class SecurityHeadersMiddleware
{
    public function __construct(private array $config) {}

    public function __invoke(Request $req, callable $next): Response
    {
        $res = $next($req);

        $csp = $this->config['security']['headers']['csp'] ?? null;
        if ($csp) {
            $res->header('Content-Security-Policy', $csp);
        }

        $res->header('X-Frame-Options', 'DENY');
        $res->header('X-Content-Type-Options', 'nosniff');
        $res->header('Referrer-Policy', 'strict-origin-when-cross-origin');

        if (!empty($this->config['security']['headers']['hsts'])) {
            $res->header('Strict-Transport-Security', 'max-age=31536000; includeSubDomains; preload');
        }

        return $res;
    }
}
