<?php
declare(strict_types=1);

require_once dirname(__DIR__) . '/DB/DB.php';

final class RrhhRatingService
{
    public static function summary(int $rrhhUserId): array
    {
        $pdo = DB::pdo();
        $st = $pdo->prepare("
            SELECT COUNT(*) c, COALESCE(AVG(score),0) avg_score
            FROM rrhh_ratings
            WHERE rrhh_user_id=:uid
        ");
        $st->execute([':uid'=>$rrhhUserId]);
        $r = $st->fetch(\PDO::FETCH_ASSOC) ?: ['c'=>0,'avg_score'=>0];
        return [
            'count' => (int)($r['c'] ?? 0),
            'avg'   => round((float)($r['avg_score'] ?? 0), 2),
        ];
    }

    public static function add(int $rrhhUserId, ?int $raterUserId, int $score, ?string $comentario): int
    {
        $pdo = DB::pdo();
        $score = max(1, min(5, $score));
        $comentario = $comentario !== null ? trim($comentario) : null;
        if ($comentario === '') $comentario = null;

        $st = $pdo->prepare("
            INSERT INTO rrhh_ratings (rrhh_user_id, rater_user_id, score, comentario, creado_en)
            VALUES (:rid,:uid,:s,:c,NOW())
        ");
        $st->bindValue(':rid', $rrhhUserId, \PDO::PARAM_INT);
        $st->bindValue(':uid', $raterUserId, $raterUserId === null ? \PDO::PARAM_NULL : \PDO::PARAM_INT);
        $st->bindValue(':s', $score, \PDO::PARAM_INT);
        $st->bindValue(':c', $comentario, $comentario === null ? \PDO::PARAM_NULL : \PDO::PARAM_STR);
        $st->execute();
        return (int)$pdo->lastInsertId();
    }
}
