<?php
declare(strict_types=1);

final class RateLimiter
{
    public function __construct(private string $cacheDir)
    {
        if (!is_dir($this->cacheDir)) {
            @mkdir($this->cacheDir, 0755, true);
        }
    }

    public function hit(string $key, int $windowSeconds, int $max): bool
    {
        $file = $this->cacheDir . '/' . sha1($key) . '.json';
        $now = time();

        $data = ['ts' => $now, 'count' => 0];

        if (is_file($file)) {
            $raw = @file_get_contents($file);
            $parsed = $raw ? json_decode($raw, true) : null;
            if (is_array($parsed) && isset($parsed['ts'], $parsed['count'])) {
                $data = $parsed;
            }
        }

        $elapsed = $now - (int)$data['ts'];

        if ($elapsed >= $windowSeconds) {
            $data = ['ts' => $now, 'count' => 1];
            @file_put_contents($file, json_encode($data), LOCK_EX);
            return true;
        }

        $count = (int)$data['count'] + 1;
        $data['count'] = $count;

        @file_put_contents($file, json_encode($data), LOCK_EX);

        return $count <= $max;
    }
}
