<?php
/** @var array $items */
/** @var string $q */
/** @var string $action */
/** @var string $entity */
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h4 class="mb-0">Auditoría</h4>
    <div class="text-muted small">Últimos eventos (máx. 500).</div>
  </div>
</div>

<div class="card mb-3">
  <div class="card-body">
    <form class="row g-2" method="get" action="<?= htmlspecialchars(base_path() . '/admin/auditoria') ?>">
      <div class="col-12 col-md-6">
        <input class="form-control" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Buscar por actor, acción, entidad, IP..." />
      </div>
      <div class="col-12 col-md-3">
        <input class="form-control" name="action" value="<?= htmlspecialchars($action) ?>" placeholder="action exacta (opcional)" />
      </div>
      <div class="col-12 col-md-3">
        <input class="form-control" name="entity" value="<?= htmlspecialchars($entity) ?>" placeholder="entity exacta (opcional)" />
      </div>
      <div class="col-12 d-grid">
        <button class="btn btn-primary" type="submit">Filtrar</button>
      </div>
    </form>
  </div>
</div>

<div class="card">
  <div class="table-responsive">
    <table class="table table-hover mb-0 align-middle">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th>Actor</th>
          <th>Acción</th>
          <th>Entidad</th>
          <th>IP</th>
          <th>Fecha</th>
          <th>Meta</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($items)): ?>
          <tr><td colspan="7" class="text-center text-muted py-4">Sin eventos.</td></tr>
        <?php else: ?>
          <?php foreach ($items as $it): ?>
            <?php
              $id = (int)($it['id'] ?? 0);
              $actor = (string)($it['actor_nombre'] ?? $it['actor_email'] ?? '—');
              $act = (string)($it['action'] ?? '');
              $ent = (string)($it['entity'] ?? '—');
              $eid = $it['entity_id'] ?? null;
              $ip  = (string)($it['ip'] ?? '—');
              $dt  = (string)($it['creado_en'] ?? '');
              $meta = (string)($it['meta_json'] ?? '');
            ?>
            <tr>
              <td class="text-muted">#<?= $id ?></td>
              <td><?= htmlspecialchars($actor) ?></td>
              <td class="fw-semibold"><?= htmlspecialchars($act) ?></td>
              <td><?= htmlspecialchars($ent) ?><?= $eid !== null ? ' #' . (int)$eid : '' ?></td>
              <td class="small text-muted"><?= htmlspecialchars($ip) ?></td>
              <td class="small text-muted"><?= htmlspecialchars($dt) ?></td>
              <td style="max-width:520px">
                <div class="small" style="white-space:pre-wrap"><?= htmlspecialchars($meta) ?></div>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
