<?php
/** @var array $items */
/** @var string $q */
/** @var string $estado */
/** @var string|null $error */
/** @var string $csrf */
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h4 class="mb-0">Moderación • Vacantes</h4>
    <div class="text-muted small">Listado global para moderación (admin).</div>
  </div>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card mb-3">
  <div class="card-body">
    <form class="row g-2" method="get" action="<?= htmlspecialchars(base_path() . '/admin/moderacion/vacantes') ?>">
      <div class="col-12 col-md-7">
        <input class="form-control" name="q" value="<?= htmlspecialchars((string)$q) ?>" placeholder="Buscar por título, empresa, email..." />
      </div>
      <div class="col-12 col-md-3">
        <select class="form-select" name="estado">
          <option value="" <?= $estado===''?'selected':'' ?>>Todos los estados</option>
          <option value="borrador"  <?= $estado==='borrador'?'selected':'' ?>>Borrador</option>
          <option value="publicada" <?= $estado==='publicada'?'selected':'' ?>>Publicada</option>
          <option value="cerrada"   <?= $estado==='cerrada'?'selected':'' ?>>Cerrada</option>
        </select>
      </div>
      <div class="col-12 col-md-2 d-grid">
        <button class="btn btn-primary" type="submit">Filtrar</button>
      </div>
    </form>
  </div>
</div>

<div class="card">
  <div class="table-responsive">
    <table class="table table-hover mb-0 align-middle">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th>Título</th>
          <th>Empresa</th>
          <th>Estado</th>
          <th>Postulaciones</th>
          <th>Creado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($items)): ?>
          <tr><td colspan="7" class="text-center text-muted py-4">Sin resultados.</td></tr>
        <?php else: ?>
          <?php foreach ($items as $it): ?>
            <?php
              $id = (int)($it['id'] ?? 0);
              $titulo = (string)($it['titulo'] ?? '');
              $empresa = (string)($it['empresa_nombre'] ?? $it['empresa_email'] ?? '');
              $est = (string)($it['estado'] ?? '');
              $cnt = (int)($it['postulaciones_count'] ?? 0);
              $cre = (string)($it['creado_en'] ?? '');
            ?>
            <tr>
              <td class="text-muted">#<?= $id ?></td>
              <td class="fw-semibold"><?= htmlspecialchars($titulo) ?></td>
              <td><?= htmlspecialchars($empresa) ?></td>
              <td><span class="badge text-bg-secondary"><?= htmlspecialchars($est) ?></span></td>
              <td><?= $cnt ?></td>
              <td class="small text-muted"><?= htmlspecialchars($cre) ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary"
                   href="<?= htmlspecialchars(base_path() . '/admin/moderacion/vacantes/ver?id=' . $id) ?>">
                  Ver
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
