<?php
/** @var array $row */
/** @var array $posts */
/** @var string|null $error */
/** @var string $csrf */

$id = (int)($row['id'] ?? 0);
$estado = (string)($row['estado'] ?? '');
$empresa = (string)($row['empresa_nombre'] ?? $row['empresa_email'] ?? '');
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h4 class="mb-0">Moderación • Vacante #<?= $id ?></h4>
    <div class="text-muted small"><?= htmlspecialchars($empresa) ?></div>
  </div>
  <a class="btn btn-outline-secondary" href="<?= htmlspecialchars(base_path() . '/admin/moderacion/vacantes') ?>">Volver</a>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card mb-3">
  <div class="card-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
      <div>
        <div class="fw-semibold"><?= htmlspecialchars((string)($row['titulo'] ?? '')) ?></div>
        <div class="small text-muted">
          Estado: <span class="badge text-bg-secondary"><?= htmlspecialchars($estado) ?></span>
          • Publicada: <?= htmlspecialchars((string)($row['publicada_en'] ?? '—')) ?>
          • Cerrada: <?= htmlspecialchars((string)($row['cerrada_en'] ?? '—')) ?>
        </div>
      </div>

      <form method="post" action="<?= htmlspecialchars(base_path() . '/admin/moderacion/vacantes/estado') ?>" class="d-flex gap-2">
        <input type="hidden" name="_csrf" value="<?= htmlspecialchars((string)$csrf) ?>">
        <input type="hidden" name="vacante_id" value="<?= $id ?>">

        <select class="form-select" name="estado">
          <option value="borrador"  <?= $estado==='borrador'?'selected':'' ?>>Borrador</option>
          <option value="publicada" <?= $estado==='publicada'?'selected':'' ?>>Publicada</option>
          <option value="cerrada"   <?= $estado==='cerrada'?'selected':'' ?>>Cerrada</option>
        </select>

        <button class="btn btn-primary" type="submit">Aplicar</button>
      </form>
    </div>

    <hr>

    <div class="small text-muted mb-1">Descripción</div>
    <div style="white-space:pre-wrap"><?= htmlspecialchars((string)($row['descripcion'] ?? '')) ?></div>
  </div>
</div>

<div class="card">
  <div class="card-body">
    <div class="fw-semibold mb-2">Postulaciones (<?= (int)($row['postulaciones_count'] ?? 0) ?>)</div>

    <?php if (empty($posts)): ?>
      <div class="alert alert-light border mb-0">No hay postulaciones.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Postulante</th>
              <th>Estado</th>
              <th>Creado</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($posts as $p): ?>
              <tr>
                <td class="text-muted">#<?= (int)($p['id'] ?? 0) ?></td>
                <td><?= htmlspecialchars((string)($p['postulante_nombre'] ?? $p['postulante_email'] ?? ('User#' . (int)($p['postulante_user_id'] ?? 0)))) ?></td>
                <td><span class="badge text-bg-secondary"><?= htmlspecialchars((string)($p['estado'] ?? '')) ?></span></td>
                <td class="small text-muted"><?= htmlspecialchars((string)($p['creado_en'] ?? '')) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
