<?php declare(strict_types=1);
/** @var array $items */
/** @var string|null $error */
$error = $error ?? null;
$bp = base_path();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-0">Módulos</h3>
    <div class="text-secondary small">Catálogo de módulos del sistema (activar/desactivar y base para planes/overrides).</div>
  </div>
  <a class="btn btn-primary" href="<?= htmlspecialchars($bp . '/admin/modules/create') ?>">
    + Nuevo módulo
  </a>
</div>

<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead>
        <tr>
          <th style="width:80px">ID</th>
          <th>Code</th>
          <th>Nombre</th>
          <th style="width:130px">Estado</th>
          <th style="width:200px">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $it): ?>
          <tr>
            <td><?= (int)$it['id'] ?></td>
            <td><code><?= htmlspecialchars((string)$it['code']) ?></code></td>
            <td><?= htmlspecialchars((string)$it['nombre']) ?></td>
            <td>
              <?php if (($it['estado'] ?? '') === 'activo'): ?>
                <span class="badge bg-success">Activo</span>
              <?php else: ?>
                <span class="badge bg-secondary">Inactivo</span>
              <?php endif; ?>
            </td>
            <td class="d-flex gap-2">
              <a class="btn btn-sm btn-outline-primary"
                 href="<?= htmlspecialchars($bp . '/admin/modules/edit?id=' . (int)$it['id']) ?>">
                Editar
              </a>

              <form method="post" action="<?= htmlspecialchars($bp . '/admin/modules/delete') ?>"
                    onsubmit="return confirm('¿Eliminar módulo?');">
                <input type="hidden" name="id" value="<?= (int)$it['id'] ?>">
                <button class="btn btn-sm btn-outline-danger" type="submit">Eliminar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if (!$items): ?>
          <tr>
            <td colspan="5" class="text-center text-secondary py-4">
              No hay módulos todavía.
            </td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
