<?php declare(strict_types=1);
/** @var string|null $error */
/** @var array $old */
/** @var string $csrf */
$bp = base_path();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Crear plan</h3>
  <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/plans') ?>">Volver</a>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body">
    <form method="post" action="<?= htmlspecialchars($bp . '/admin/plans/create') ?>" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">

      <div class="col-md-4">
        <label class="form-label">Code</label>
        <input class="form-control" name="code"
               value="<?= htmlspecialchars((string)($old['code'] ?? '')) ?>"
               placeholder="PRO, BASIC, EMPRESA_10" required>
        <div class="form-text">MAYÚSCULAS, números o _ (2 a 50).</div>
      </div>

      <div class="col-md-8">
        <label class="form-label">Nombre</label>
        <input class="form-control" name="nombre"
               value="<?= htmlspecialchars((string)($old['nombre'] ?? '')) ?>"
               placeholder="Plan Pro" required>
      </div>

      <div class="col-12">
        <label class="form-label">Descripción</label>
        <textarea class="form-control" name="descripcion" rows="2"
                  placeholder="Opcional"><?= htmlspecialchars((string)($old['descripcion'] ?? '')) ?></textarea>
      </div>

      <div class="col-md-4">
        <label class="form-label">Precio mensual</label>
        <input class="form-control" name="precio_mensual"
               value="<?= htmlspecialchars((string)($old['precio_mensual'] ?? '0.00')) ?>"
               placeholder="0.00" required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Precio anual</label>
        <input class="form-control" name="precio_anual"
               value="<?= htmlspecialchars((string)($old['precio_anual'] ?? '0.00')) ?>"
               placeholder="0.00" required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Estado</label>
        <select class="form-select" name="estado">
          <option value="activo" <?= (($old['estado'] ?? 'activo')==='activo'?'selected':'') ?>>Activo</option>
          <option value="inactivo" <?= (($old['estado'] ?? 'activo')==='inactivo'?'selected':'') ?>>Inactivo</option>
        </select>
      </div>

      <div class="col-12">
        <button class="btn btn-primary" type="submit">Guardar</button>
        <a class="btn btn-light" href="<?= htmlspecialchars($bp . '/admin/plans') ?>">Cancelar</a>
      </div>
    </form>
  </div>
</div>
