<?php declare(strict_types=1);
/** @var array $items */
/** @var string|null $error */
/** @var string $csrf */
$bp = base_path();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Planes</h3>
  <a class="btn btn-primary" href="<?= htmlspecialchars($bp . '/admin/plans/create') ?>">
    <i class="bi bi-plus-lg"></i> Nuevo plan
  </a>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-striped align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th style="width:70px;">ID</th>
            <th>Code</th>
            <th>Nombre</th>
            <th class="text-end">Mensual</th>
            <th class="text-end">Anual</th>
            <th>Estado</th>
            <th style="width:180px;" class="text-end">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($items)): ?>
          <tr>
            <td colspan="7" class="text-center text-muted py-4">No hay planes.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($items as $it): ?>
            <?php
              $id = (int)$it['id'];
              $isFree = (($it['code'] ?? '') === 'FREE');
            ?>
            <tr>
              <td><?= (int)$it['id'] ?></td>
              <td class="fw-semibold"><?= htmlspecialchars((string)$it['code']) ?></td>
              <td>
                <div class="fw-semibold"><?= htmlspecialchars((string)$it['nombre']) ?></div>
                <?php if (!empty($it['descripcion'])): ?>
                  <div class="small text-muted"><?= htmlspecialchars((string)$it['descripcion']) ?></div>
                <?php endif; ?>
              </td>
              <td class="text-end"><?= htmlspecialchars((string)$it['precio_mensual']) ?></td>
              <td class="text-end"><?= htmlspecialchars((string)$it['precio_anual']) ?></td>
              <td>
                <?php if (($it['estado'] ?? '') === 'activo'): ?>
                  <span class="badge text-bg-success">Activo</span>
                <?php else: ?>
                  <span class="badge text-bg-secondary">Inactivo</span>
                <?php endif; ?>
              </td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary"
                   href="<?= htmlspecialchars($bp . '/admin/plans/edit?id=' . $id) ?>">
                  <i class="bi bi-pencil"></i> Editar
                </a>

                <form method="post" action="<?= htmlspecialchars($bp . '/admin/plans/delete') ?>"
                      class="d-inline"
                      onsubmit="return confirm('¿Eliminar este plan? Esta acción no se puede deshacer.');">
                  <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)$id ?>">
                  <button class="btn btn-sm btn-outline-danger" type="submit" <?= $isFree ? 'disabled' : '' ?>>
                    <i class="bi bi-trash"></i> Eliminar
                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
