<?php
declare(strict_types=1);

$csrf = CsrfToken::issue();
?>
<div class="container py-5" style="max-width:520px;">
  <div class="card shadow-sm border-0">
    <div class="card-body p-4">
      <h1 class="h5 mb-2">Iniciar sesión</h1>
      <p class="text-muted small mb-4">Acceso seguro con CSRF, captcha propio y rate limit.</p>

      <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
      <?php endif; ?>

      <form method="post" action="/public/login" autocomplete="off">
        <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">

        <div class="mb-3">
          <label class="form-label">Correo</label>
          <input class="form-control" name="email" type="email" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Contraseña</label>
          <input class="form-control" name="password" type="password" required>
        </div>

        <div class="mb-3">
          <label class="form-label d-flex justify-content-between">
            <span>Captcha</span>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.getElementById('cap').src='/public/captcha?ts='+Date.now()">Recargar</button>
          </label>
          <div class="d-flex gap-2 align-items-center">
            <img id="cap" src="/public/captcha" alt="captcha" style="border-radius:10px;border:1px solid #e9ecef;">
            <input class="form-control" name="captcha" type="text" placeholder="Ej: A8K2QZ" required>
          </div>
        </div>

        <button class="btn btn-primary w-100">Entrar</button>
        <?php if (!empty($GLOBALS['APP_CONFIG']['google_oauth']['enabled'])): ?>
          <div class="d-grid mt-3">
            <a class="btn btn-outline-dark" href="<?= htmlspecialchars(base_path() . '/auth/google') ?>">
              Continuar con Google
            </a>
          </div>
        <?php endif; ?>
        <div class="mt-3 text-center">
          <a href="/public/registro" class="small">Crear cuenta</a>
        </div>
      </form>
    </div>
  </div>
</div>