<?php
declare(strict_types=1);

$csrf = CsrfToken::issue();

// Si vienes con "old" desde el controller, lo usamos; si no, defaults
$oldEmail = htmlspecialchars((string)($old['email'] ?? ''), ENT_QUOTES, 'UTF-8');
$oldTipo  = (string)($old['tipo'] ?? 'postulante');

function selected(string $v, string $current): string {
  return $v === $current ? 'selected' : '';
}
?>
<div class="container py-5" style="max-width:560px;">
  <div class="card shadow-sm border-0">
    <div class="card-body p-4">
      <h1 class="h5 mb-2">Crear cuenta</h1>
      <p class="text-muted small mb-4">Registro seguro (CSRF + captcha + contraseña fuerte).</p>

      <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
      <?php endif; ?>

      <?php if (!empty($ok)): ?>
        <div class="alert alert-success">Registro completado. Ahora puedes iniciar sesión.</div>
      <?php endif; ?>

      <form method="post" action="/public/registro" autocomplete="off">
        <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">

        <div class="mb-3">
          <label class="form-label">Correo</label>
          <input class="form-control" name="email" type="email" required value="<?= $oldEmail ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Contraseña</label>
          <input class="form-control" name="password" type="password" required>
          <div class="form-text">Mínimo 10 chars, mayúscula, minúscula y número.</div>
        </div>

        <div class="mb-3">
          <label class="form-label">Tipo de cuenta</label>
          <select class="form-select" name="tipo" required>
            <option value="postulante" <?= selected('postulante', $oldTipo) ?>>Postulante</option>
            <option value="empresa" <?= selected('empresa', $oldTipo) ?>>Empresa</option>
            <option value="rrhh" <?= selected('rrhh', $oldTipo) ?>>RRHH</option>
            <option value="orador" <?= selected('orador', $oldTipo) ?>>Orador</option>
            <option value="profesional" <?= selected('profesional', $oldTipo) ?>>Profesional</option>
          </select>
          <div class="form-text">
            Postulante: busca empleo. Empresa/RRHH: publica y gestiona vacantes. Orador/Profesional: perfil relacionado a empleo.
          </div>
        </div>

        <div class="mb-3">
          <label class="form-label d-flex justify-content-between">
            <span>Captcha</span>
            <button type="button" class="btn btn-sm btn-outline-secondary"
              onclick="document.getElementById('cap').src='/public/captcha?ts='+Date.now()">
              Recargar
            </button>
          </label>
          <div class="d-flex gap-2 align-items-center">
            <img id="cap" src="/public/captcha" alt="captcha"
              style="border-radius:10px;border:1px solid #e9ecef;">
            <input class="form-control" name="captcha" type="text" placeholder="Ej: A8K2QZ" required>
          </div>
        </div>

        <button class="btn btn-primary w-100">Crear cuenta</button>

        <?php if (!empty($GLOBALS['APP_CONFIG']['google_oauth']['enabled'])): ?>
          <div class="d-grid mt-3">
            <a class="btn btn-outline-dark" href="<?= htmlspecialchars(base_path() . '/auth/google') ?>">
              Continuar con Google
            </a>
          </div>
        <?php endif; ?>

        <div class="mt-3 text-center">
          <a href="/public/login" class="small">Ya tengo cuenta</a>
        </div>
      </form>
    </div>
  </div>
</div>
