<?php
/** @var array $vacante */
/** @var array $items */
/** @var string|null $error */
/** @var string $csrf */

$badge = function (string $estado): string {
  return match ($estado) {
    'vista'         => 'info',
    'preseleccion'  => 'success',
    'rechazada'     => 'danger',
    default         => 'secondary',
  };
};
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Postulaciones</h3>
      <div class="text-muted small">
        Vacante: <?= htmlspecialchars((string)($vacante['titulo'] ?? '')) ?> (ID #<?= (int)($vacante['id'] ?? 0) ?>)
      </div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars(url_path('empresa/vacantes')) ?>">Volver</a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Postulante</th>
              <th>Mensaje</th>
              <th>Estado</th>
              <th>Creado</th>
              <th class="text-end">Acciones</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($items)): ?>
              <tr>
                <td colspan="6" class="text-center text-muted py-4">Aún no hay postulaciones.</td>
              </tr>
            <?php else: ?>
              <?php foreach ($items as $it): ?>
                <?php
                  $pid = (int)($it['id'] ?? 0);
                  $estado = (string)($it['estado'] ?? 'enviada');
                  $postulanteLabel = (string)($it['postulante_email'] ?? ('User #' . (int)($it['postulante_user_id'] ?? 0)));
                  $vacanteId = (int)($vacante['id'] ?? 0);
                ?>
                <tr>
                  <td class="text-muted">#<?= $pid ?></td>

                  <td><?= htmlspecialchars($postulanteLabel) ?></td>

                  <td style="max-width:520px">
                    <div style="white-space:pre-wrap"><?= htmlspecialchars((string)($it['mensaje'] ?? '')) ?></div>
                  </td>

                  <td>
                    <span class="badge text-bg-<?= $badge($estado) ?>"><?= htmlspecialchars($estado) ?></span>
                  </td>

                  <td class="small text-muted"><?= htmlspecialchars((string)($it['creado_en'] ?? '')) ?></td>

                  <td class="text-end">
                    <?php $states = ['enviada' => 'Enviada', 'vista' => 'Vista', 'preseleccion' => 'Preselección', 'rechazada' => 'Rechazada']; ?>

                    <div class="d-inline-flex align-items-center gap-2">
                      <!-- Descargar CV -->
                      <a
                        class="btn btn-sm btn-outline-secondary"
                        href="<?= htmlspecialchars(url_path('empresa/postulaciones/cv')) ?>?postulacion_id=<?= $pid ?>"
                        title="Descargar CV del postulante"
                      >
                        Descargar CV
                      </a>

                      <!-- Cambiar estado -->
                      <form method="post" action="<?= htmlspecialchars(url_path('empresa/postulaciones/estado')) ?>" class="d-inline-flex gap-2">
                        <input type="hidden" name="_csrf" value="<?= htmlspecialchars((string)$csrf) ?>">
                        <input type="hidden" name="postulacion_id" value="<?= $pid ?>">
                        <input type="hidden" name="vacante_id" value="<?= $vacanteId ?>">

                        <select class="form-select form-select-sm" name="estado">
                          <?php foreach ($states as $k => $label): ?>
                            <option value="<?= htmlspecialchars($k) ?>" <?= $estado === $k ? 'selected' : '' ?>>
                              <?= htmlspecialchars($label) ?>
                            </option>
                          <?php endforeach; ?>
                        </select>

                        <button class="btn btn-sm btn-outline-primary" type="submit">Actualizar</button>
                      </form>
                    </div>

                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>