<?php declare(strict_types=1);
/** @var string|null $error */
/** @var array $old */
/** @var string $csrf */
/** @var array $categorias  // [{id,nombre}] */
/** @var array $oldCategorias // [int,int,...] */

$bp = base_path();
$old = $old ?? [];
$categorias = $categorias ?? [];
$oldCategorias = $oldCategorias ?? [];

$titulo      = (string)($old['titulo'] ?? '');
$descripcion = (string)($old['descripcion'] ?? '');
$ubicacion   = (string)($old['ubicacion'] ?? '');
$modalidad   = (string)($old['modalidad'] ?? 'presencial');
$tipoEmpleo  = (string)($old['tipo_empleo'] ?? 'tiempo_completo');
$salarioMin  = (string)($old['salario_min'] ?? '');
$salarioMax  = (string)($old['salario_max'] ?? '');
$moneda      = strtoupper((string)($old['moneda'] ?? 'CRC'));
?>

<style>
  .editor-wrap{border:1px solid #e8eefc;border-radius:12px;overflow:hidden;background:#fff}
  .editor-toolbar{display:flex;flex-wrap:wrap;gap:6px;padding:10px;border-bottom:1px solid #e8eefc;background:#f7f9ff}
  .editor-toolbar button{border:1px solid #e8eefc;background:#fff;border-radius:10px;padding:6px 10px;font-size:14px}
  .editor-toolbar button:hover{background:#f1f5ff}
  .editor-area{min-height:220px;padding:12px;outline:none}
  .editor-area:empty:before{content:attr(data-placeholder);color:#8896b1}

  .cat-box{border:1px solid #e8eefc;border-radius:12px;background:#fff}
  .cat-top{padding:10px;border-bottom:1px solid #e8eefc;background:#fbfcff}
  .cat-list{max-height:260px;overflow:auto}
  .cat-item{display:flex;align-items:center;gap:10px;padding:10px 12px;border-bottom:1px solid #f1f3fb}
  .cat-item:last-child{border-bottom:0}
  .cat-chip{display:inline-flex;align-items:center;gap:8px;padding:6px 10px;border:1px solid #e8eefc;border-radius:999px;background:#f7f9ff;font-size:13px}
  .cat-chip button{border:0;background:transparent;font-weight:800;line-height:1}

  .img-preview{
    width:100%;max-width:420px;aspect-ratio:1080/1180;
    border:1px dashed #cfd8ee;border-radius:14px;
    display:flex;align-items:center;justify-content:center;
    overflow:hidden;background:#fbfcff
  }
  .img-preview img{width:100%;height:100%;object-fit:cover}
</style>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Nueva vacante</h3>
      <div class="text-muted small">Crea un borrador y publícalo cuando esté listo.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= e($bp . '/empresa/vacantes') ?>">Volver</a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= e((string)$error) ?></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <form method="post"
            action="<?= e($bp . '/empresa/vacantes/create') ?>"
            enctype="multipart/form-data"
            class="row g-3">

        <input type="hidden" name="_csrf" value="<?= e((string)$csrf) ?>">

        <div class="col-12">
          <label class="form-label">Título</label>
          <input class="form-control" name="titulo" required
                 value="<?= e($titulo) ?>"
                 placeholder="Ej: Desarrollador PHP 8 (Remoto)">
        </div>

        <!-- Categorías: selector inteligente (sin librerías) -->
        <div class="col-12">
          <label class="form-label">Categorías laborales</label>

          <div class="cat-box">
            <div class="cat-top">
              <input id="catSearch" class="form-control" placeholder="Buscar categoría...">
              <div class="form-text mt-2">Seleccioná 1 o más categorías. Esto alimenta el matching y el feed.</div>

              <div id="catChips" class="d-flex flex-wrap gap-2 mt-2"></div>
            </div>

            <div class="cat-list" id="catList">
              <?php foreach ($categorias as $c): ?>
                <?php
                  $cid = (int)($c['id'] ?? 0);
                  $cn  = (string)($c['nombre'] ?? '');
                  $sel = in_array($cid, $oldCategorias, true);
                  $idFor = 'cat_' . $cid;
                ?>
                <label class="cat-item" data-name="<?= e(mb_strtolower($cn)) ?>">
                  <input
                    class="form-check-input cat-check"
                    type="checkbox"
                    name="categoria_ids[]"
                    value="<?= $cid ?>"
                    id="<?= e($idFor) ?>"
                    <?= $sel ? 'checked' : '' ?>
                  >
                  <span><?= e($cn) ?></span>
                </label>
              <?php endforeach; ?>

              <?php if (empty($categorias)): ?>
                <div class="p-3 text-muted">No hay categorías cargadas (revisar tabla/estado).</div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Imagen -->
        <div class="col-12">
          <label class="form-label">Imagen (opcional)</label>

          <div class="row g-3 align-items-start">
            <div class="col-12 col-lg-5">
              <div class="img-preview">
                <div class="text-muted small text-center px-3" id="imgPreviewEmpty">
                  Recomendado: <strong>1080 x 1180</strong><br>
                  (se mostrará ajustada en el feed)
                </div>
                <img id="imgPreview" src="" alt="" style="display:none;">
              </div>

              <div class="form-text mt-2">
                Al guardar, el backend optimiza a <strong>AVIF</strong> si tu PHP lo soporta, o a <strong>WebP</strong>.
              </div>
            </div>

            <div class="col-12 col-lg-7">
              <input class="form-control" type="file" name="imagen" accept="image/*" id="imgInput">
              <div class="form-text">
                JPG/PNG/WebP/AVIF. No limitamos tamaño, pero evitá imágenes gigantes.
              </div>
            </div>
          </div>
        </div>

        <!-- Editor -->
        <div class="col-12">
          <label class="form-label">Descripción</label>

          <div class="editor-wrap">
            <div class="editor-toolbar">
              <button type="button" data-cmd="bold" title="Negrita"><strong>B</strong></button>
              <button type="button" data-cmd="italic" title="Cursiva"><em>I</em></button>
              <button type="button" data-cmd="underline" title="Subrayado"><u>U</u></button>
              <span class="mx-1"></span>
              <button type="button" data-cmd="insertUnorderedList" title="Lista">• Lista</button>
              <button type="button" data-cmd="insertOrderedList" title="Numerada">1. Lista</button>
              <span class="mx-1"></span>
              <button type="button" id="btnLink" title="Enlace">Link</button>
              <button type="button" id="btnClear" title="Limpiar formato">Limpiar</button>
              <div class="ms-auto text-muted small d-flex align-items-center gap-2">
                <span class="cat-chip">Chars: <strong id="charCount">0</strong></span>
              </div>
            </div>

            <div id="editor" class="editor-area" contenteditable="true"
                 data-placeholder="Describe funciones, requisitos, beneficios..."><?= $descripcion !== '' ? $descripcion : '' ?></div>
          </div>

          <textarea class="form-control mt-2" name="descripcion" id="descripcion"
                    rows="6" required style="display:none;"><?= e($descripcion) ?></textarea>

          <div class="form-text">Mínimo recomendado: 20 caracteres.</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Ubicación</label>
          <input class="form-control" name="ubicacion"
                 value="<?= e($ubicacion) ?>"
                 placeholder="Ej: San José, CR (opcional)">
        </div>

        <div class="col-md-3">
          <label class="form-label">Modalidad</label>
          <select class="form-select" name="modalidad">
            <option value="presencial" <?= $modalidad==='presencial'?'selected':'' ?>>Presencial</option>
            <option value="remoto" <?= $modalidad==='remoto'?'selected':'' ?>>Remoto</option>
            <option value="hibrido" <?= $modalidad==='hibrido'?'selected':'' ?>>Híbrido</option>
          </select>
        </div>

        <div class="col-md-3">
          <label class="form-label">Tipo empleo</label>
          <select class="form-select" name="tipo_empleo">
            <option value="tiempo_completo" <?= $tipoEmpleo==='tiempo_completo'?'selected':'' ?>>Tiempo completo</option>
            <option value="medio_tiempo" <?= $tipoEmpleo==='medio_tiempo'?'selected':'' ?>>Medio tiempo</option>
            <option value="temporal" <?= $tipoEmpleo==='temporal'?'selected':'' ?>>Temporal</option>
            <option value="freelance" <?= $tipoEmpleo==='freelance'?'selected':'' ?>>Freelance</option>
            <option value="practica" <?= $tipoEmpleo==='practica'?'selected':'' ?>>Práctica</option>
          </select>
        </div>

        <div class="col-md-3">
          <label class="form-label">Salario mín.</label>
          <input class="form-control" name="salario_min" inputmode="decimal"
                 value="<?= e($salarioMin) ?>" placeholder="opcional">
        </div>

        <div class="col-md-3">
          <label class="form-label">Salario máx.</label>
          <input class="form-control" name="salario_max" inputmode="decimal"
                 value="<?= e($salarioMax) ?>" placeholder="opcional">
        </div>

        <div class="col-md-2">
          <label class="form-label">Moneda</label>
          <select class="form-select" name="moneda">
            <option value="CRC" <?= $moneda==='CRC'?'selected':'' ?>>CRC</option>
            <option value="USD" <?= $moneda==='USD'?'selected':'' ?>>USD</option>
          </select>
        </div>

        <div class="col-12 d-flex gap-2">
          <button class="btn btn-primary" type="submit">Guardar (Borrador)</button>
          <a class="btn btn-light" href="<?= e($bp . '/empresa/vacantes') ?>">Cancelar</a>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
(function(){
  // ===== Editor =====
  const editor = document.getElementById('editor');
  const textarea = document.getElementById('descripcion');
  const charCount = document.getElementById('charCount');

  function syncToTextarea(){
    textarea.value = editor.innerHTML.trim();
    charCount.textContent = ((editor.innerText || '').trim().length).toString();
  }

  document.querySelectorAll('.editor-toolbar button[data-cmd]').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const cmd = btn.getAttribute('data-cmd');
      document.execCommand(cmd, false, null);
      editor.focus();
      syncToTextarea();
    });
  });

  document.getElementById('btnLink').addEventListener('click', ()=>{
    const url = prompt('URL (https://...)');
    if (!url) return;
    document.execCommand('createLink', false, url);
    editor.focus();
    syncToTextarea();
  });

  document.getElementById('btnClear').addEventListener('click', ()=>{
    document.execCommand('removeFormat', false, null);
    editor.querySelectorAll('script,style').forEach(n=>n.remove());
    editor.focus();
    syncToTextarea();
  });

  editor.addEventListener('input', syncToTextarea);
  syncToTextarea();

  // ===== Imagen preview =====
  // IMPORTANTE: FileReader (data URL) evita bloqueo CSP de blob:
  const imgInput = document.getElementById('imgInput');
  const img = document.getElementById('imgPreview');
  const empty = document.getElementById('imgPreviewEmpty');

  imgInput.addEventListener('change', ()=>{
    const f = imgInput.files && imgInput.files[0];
    if (!f) {
      img.style.display = 'none';
      empty.style.display = 'block';
      img.src = '';
      return;
    }
    const reader = new FileReader();
    reader.onload = (ev)=>{
      img.src = String(ev.target.result || '');
      img.style.display = 'block';
      empty.style.display = 'none';
    };
    reader.readAsDataURL(f);
  });

  // ===== Categorías: filtro + chips =====
  const search = document.getElementById('catSearch');
  const list = document.getElementById('catList');
  const chips = document.getElementById('catChips');

  function rebuildChips(){
    chips.innerHTML = '';
    const checked = list.querySelectorAll('.cat-check:checked');
    checked.forEach(ch=>{
      const label = ch.closest('label');
      const text = (label ? label.textContent : ch.value).trim();
      const chip = document.createElement('span');
      chip.className = 'cat-chip';
      chip.innerHTML = '<span>'+escapeHtml(text)+'</span><button type="button" aria-label="Quitar">×</button>';
      chip.querySelector('button').addEventListener('click', ()=>{
        ch.checked = false;
        rebuildChips();
      });
      chips.appendChild(chip);
    });
  }

  function escapeHtml(s){
    return s.replace(/[&<>"']/g, m => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m]));
  }

  list.querySelectorAll('.cat-check').forEach(ch=>{
    ch.addEventListener('change', rebuildChips);
  });

  search.addEventListener('input', ()=>{
    const q = (search.value || '').trim().toLowerCase();
    list.querySelectorAll('label[data-name]').forEach(row=>{
      const name = row.getAttribute('data-name') || '';
      row.style.display = (q === '' || name.includes(q)) ? '' : 'none';
    });
  });

  rebuildChips();
})();
</script>
