<?php
/** @var array $items */
/** @var string|null $error */

$bp = base_path();

$badge = function (string $estado): string {
  return match ($estado) {
    'publicada' => 'success',
    'cerrada'   => 'secondary',
    default     => 'warning',
  };
};
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Mis vacantes</h3>
      <div class="text-muted small">Gestiona tus publicaciones (borrador / publicada / cerrada).</div>
    </div>
    <a class="btn btn-primary" href="<?= htmlspecialchars($bp . '/empresa/vacantes/create') ?>">
      <i class="bi bi-plus-lg me-1"></i> Nueva vacante
    </a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Título</th>
              <th>Ubicación</th>
              <th>Modalidad</th>
              <th>Tipo</th>
              <th>Salario</th>
              <th>Estado</th>
              <th class="text-end">Acciones</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($items)): ?>
            <tr>
              <td colspan="8" class="text-center text-muted py-4">
                No tienes vacantes aún. Crea tu primera vacante.
              </td>
            </tr>
          <?php else: ?>
            <?php foreach ($items as $it): ?>
              <?php
                $id = (int)$it['id'];
                $smin = $it['salario_min'];
                $smax = $it['salario_max'];
                $mon  = $it['moneda'] ?? 'CRC';

                $sal = '—';
                if ($smin !== null || $smax !== null) {
                  $a = $smin !== null ? number_format((float)$smin, 2) : '—';
                  $b = $smax !== null ? number_format((float)$smax, 2) : '—';
                  $sal = "{$mon} {$a} - {$b}";
                }

                $estado = $it['estado'] ?? 'borrador';
              ?>
              <tr>
                <td class="text-muted">#<?= $id ?></td>
                <td class="fw-semibold"><?= htmlspecialchars($it['titulo']) ?></td>
                <td><?= htmlspecialchars($it['ubicacion'] ?? '—') ?></td>
                <td><?= htmlspecialchars($it['modalidad']) ?></td>
                <td><?= htmlspecialchars($it['tipo_empleo']) ?></td>
                <td><?= htmlspecialchars($sal) ?></td>
                <td>
                  <span class="badge text-bg-<?= $badge($estado) ?>">
                    <?= htmlspecialchars($estado) ?>
                  </span>
                </td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary"
                     href="<?= htmlspecialchars($bp . '/empresa/vacantes/edit?id=' . $id) ?>">
                    Editar
                  </a>
                  
                  <a class="btn btn-sm btn-outline-secondary ms-1"
                     href="<?= htmlspecialchars($bp . '/empresa/postulaciones?vacante_id=' . $id) ?>">
                    Postulaciones
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
