<?php
/** @var array $tree */
/** @var array $selected */
/** @var array $vacante */
/** @var string $csrf */

$bp = base_path();
$sel = array_flip(array_map('intval', $selected));
$vacId = (int)$vacante['id'];
?>

<div class="container py-3">
  <div class="app-card p-3 mb-3">
    <div class="d-flex justify-content-between align-items-start">
      <div>
        <div class="fw-semibold">Roles de la vacante</div>
        <div class="small app-muted">
          <?= htmlspecialchars((string)($vacante['titulo'] ?? 'Vacante')) ?> (ID: <?= $vacId ?>)
        </div>
      </div>
      <a class="btn btn-outline-secondary btn-sm" href="<?= htmlspecialchars($bp . '/empresa/vacantes') ?>">Volver</a>
    </div>
  </div>

  <form method="post" action="<?= htmlspecialchars($bp . '/empresa/vacantes/roles/guardar') ?>">
    <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
    <input type="hidden" name="vacante_id" value="<?= $vacId ?>">

    <div class="row g-3">
      <div class="col-12 col-lg-8">
        <?php foreach ($tree as $root): ?>
          <div class="app-card p-3 mb-3">
            <div class="fw-semibold mb-2"><?= htmlspecialchars($root['root']['nombre']) ?></div>

            <?php foreach ($root['familias'] as $fam): ?>
              <div class="border rounded-3 p-3 mb-2" style="border-color:#e8eefc;">
                <div class="fw-semibold mb-2"><?= htmlspecialchars($fam['familia']['nombre']) ?></div>

                <div class="row g-2">
                  <?php foreach ($fam['roles'] as $role): ?>
                    <?php $rid = (int)$role['id']; ?>
                    <div class="col-12 col-md-6">
                      <label class="d-flex gap-2 align-items-start">
                        <input class="form-check-input mt-1"
                               type="checkbox"
                               name="roles[]"
                               value="<?= $rid ?>"
                               <?= isset($sel[$rid]) ? 'checked' : '' ?>>
                        <span class="small"><?= htmlspecialchars($role['nombre']) ?></span>
                      </label>
                    </div>
                  <?php endforeach; ?>
                </div>

              </div>
            <?php endforeach; ?>

          </div>
        <?php endforeach; ?>
      </div>

      <div class="col-12 col-lg-4">
        <div class="app-card p-3">
          <div class="fw-semibold mb-2">Regla práctica</div>
          <div class="small app-muted mb-3">
            Seleccioná 1–5 roles por vacante para que el matching sea preciso.
          </div>
          <button class="btn btn-primary w-100" type="submit">Guardar roles</button>
        </div>
      </div>
    </div>
  </form>
</div>
