<?php
/** @var array $items */
$bp = base_path();
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Empresas</h3>
      <div class="text-muted small">Explora empresas con vacantes publicadas.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/vacantes') ?>">Ver vacantes</a>
  </div>

  <?php if (empty($items)): ?>
    <div class="alert alert-light border">No hay empresas registradas por ahora.</div>
  <?php else: ?>
    <div class="row g-3">
  <?php foreach ($items as $it): ?>
    <?php
      $id    = (int)($it['id'] ?? 0);
      $nombre= (string)($it['nombre'] ?? '');
      $email = (string)($it['email'] ?? '');
      $ubic  = (string)($it['ubicacion'] ?? '');
      $logo  = (string)($it['logo_path'] ?? '');
      $vac   = (int)($it['vacantes_publicadas'] ?? 0);
      $verif = (int)($it['email_verificado'] ?? 0);
      $rep   = (float)($it['reputacion_score'] ?? 0);

      // Normalización mínima (tu hosting sirve /public/upload/..)
      $logoUrl = '';
      if ($logo !== '') {
        $p = $logo;
        if (!str_starts_with($p, '/')) $p = '/' . $p;
        if (str_starts_with($p, '/upload/')) $p = '/public' . $p;
        $logoUrl = rtrim($bp, '/') . $p;
        $logoUrl = str_replace('/public/public/', '/public/', $logoUrl);
      }

      $repBadge = 'bg-secondary';
      if ($rep >= 8.5) $repBadge = 'bg-success';
      elseif ($rep >= 7.0) $repBadge = 'bg-primary';
      elseif ($rep >= 5.5) $repBadge = 'bg-warning';
      elseif ($rep > 0) $repBadge = 'bg-danger';
    ?>
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card h-100">
        <div class="card-body d-flex gap-3">
          <div style="width:68px;height:68px;border-radius:14px;border:1px solid #eef2ff;background:#fff;display:flex;align-items:center;justify-content:center;overflow:hidden;flex:0 0 auto;">
            <?php if ($logoUrl !== ''): ?>
              <img src="<?= e($logoUrl) ?>" alt="Logo empresa" style="width:100%;height:100%;object-fit:contain" loading="lazy" onerror="this.style.display='none';">
            <?php else: ?>
              <span class="text-muted small">Sin logo</span>
            <?php endif; ?>
          </div>

          <div class="flex-grow-1">
            <div class="d-flex align-items-center justify-content-between">
              <div class="fw-semibold"><?= e($nombre !== '' ? $nombre : ('Empresa #' . $id)) ?></div>
              <span class="badge <?= e($repBadge) ?>">★ <?= number_format($rep, 2) ?></span>
            </div>

            <div class="small text-muted">
              <?= e($ubic !== '' ? $ubic : $email) ?>
              <?php if ($verif === 1): ?>
                <span class="ms-1 badge bg-light text-dark border">Verificada</span>
              <?php endif; ?>
            </div>

            <div class="mt-2">
              <span class="badge bg-light text-dark border">Vacantes publicadas: <strong><?= (int)$vac ?></strong></span>
            </div>
          </div>
        </div>

        <div class="card-footer bg-white border-0 pt-0">
          <a class="btn btn-sm btn-outline-primary w-100"
             href="<?= htmlspecialchars(url_path('empresas/ver') . '?id=' . $id) ?>">
            Ver perfil
          </a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>
  <?php endif; ?>
</div>
