<?php
/** @var array $items */
$bp = base_path();
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Vacantes</h3>
      <div class="text-muted small">Explora vacantes publicadas.</div>
    </div>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="<?= htmlspecialchars(url_path('empresas')) ?>">Empresas</a>
      <a class="btn btn-outline-secondary btn-sm" href="<?= htmlspecialchars($bp . '/feed') ?>">Feed</a>
    </div>
  </div>

  <div class="row g-3">
    <?php if (empty($items)): ?>
      <div class="col-12">
        <div class="alert alert-light border">No hay vacantes publicadas por ahora.</div>
      </div>
    <?php else: ?>
      <?php foreach ($items as $it): ?>
        <?php
          $id = (int)($it['id'] ?? 0);

          $mon  = (string)($it['moneda'] ?? 'CRC');
          $smin = $it['salario_min'] ?? null;
          $smax = $it['salario_max'] ?? null;

          $sal = '—';
          if ($smin !== null || $smax !== null) {
            $a = $smin !== null ? number_format((float)$smin, 2) : '—';
            $b = $smax !== null ? number_format((float)$smax, 2) : '—';
            $sal = "{$mon} {$a} - {$b}";
          }

          $slug = (string)($it['slug'] ?? '');
          $href = url_path('vacantes/ver') . '?id=' . $id;
          if ($slug !== '') {
            $href = url_path('vacante') . '?slug=' . rawurlencode($slug);
          }
        ?>

        <div class="col-12 col-md-6 col-lg-4">
          <div class="card h-100">
            <div class="card-body">
              <div class="fw-semibold mb-1"><?= htmlspecialchars((string)($it['titulo'] ?? '')) ?></div>

              <?php if (!empty($it['empresa_user_id'])): ?>
                <div class="small mb-2">
                  Empresa:
                  <a href="<?= htmlspecialchars(url_path('empresas/ver') . '?id=' . (int)$it['empresa_user_id']) ?>">
                    <?= htmlspecialchars((string)($it['empresa_nombre'] ?? ($it['empresa_email'] ?? 'Ver perfil'))) ?>
                  </a>
                </div>
              <?php endif; ?>

              <div class="small text-muted mb-2">
                <?= htmlspecialchars((string)($it['ubicacion'] ?? '—')) ?> •
                <?= htmlspecialchars((string)($it['modalidad'] ?? '—')) ?> •
                <?= htmlspecialchars((string)($it['tipo_empleo'] ?? '—')) ?>
              </div>

              <div class="small">Salario: <?= htmlspecialchars($sal) ?></div>
            </div>

            <div class="card-footer bg-white border-0 pt-0">
              <a class="btn btn-sm btn-outline-primary w-100" href="<?= htmlspecialchars($href) ?>">
                Ver detalle
              </a>
            </div>
          </div>
        </div>

      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</div>
