<?php
declare(strict_types=1);
/**
 * Variables:
 * - array  $ideales
 * - string $bp
 */

$ideales = is_array($ideales) ? $ideales : [];
if (empty($ideales)) return;

// desktop: 3 | mobile: 5
$desk = array_slice($ideales, 0, 3);
$mob  = array_slice($ideales, 0, 5);
?>

<style>
/* carousel infinito SOLO móvil */
.ideal-infinite { overflow:hidden; width:100%; }
.ideal-track { display:flex; gap:12px; will-change: transform; animation: idealScroll 22s linear infinite; }
.ideal-item { flex:0 0 88%; }
@keyframes idealScroll { from{transform:translateX(0);} to{transform:translateX(-50%);} }
</style>

<!-- DESKTOP: 3 hacia abajo -->
<div class="d-none d-lg-block mt-3">
  <div class="fw-semibold mb-2">Ideales para ti</div>
  <?php foreach ($desk as $it): ?>
    <?= render_template('partials/vacante_card_mini.php', ['it'=>$it,'bp'=>$bp]) ?>
  <?php endforeach; ?>
</div>

<!-- MOBILE: 5 en carousel infinito -->
<div class="d-lg-none mt-3">
  <div class="fw-semibold mb-2">Ideales para ti</div>

  <div class="ideal-infinite">
    <div class="ideal-track">
      <?php foreach ($mob as $it): ?>
        <div class="ideal-item">
          <?= render_template('partials/vacante_card_mini.php', ['it'=>$it,'bp'=>$bp]) ?>
        </div>
      <?php endforeach; ?>

      <!-- duplicado para loop infinito -->
      <?php foreach ($mob as $it): ?>
        <div class="ideal-item">
          <?= render_template('partials/vacante_card_mini.php', ['it'=>$it,'bp'=>$bp]) ?>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
