<?php
declare(strict_types=1);
/** @var string $active */
$bp = base_path();
$active = $active ?? '';
$mk = fn(string $k) => $active === $k ? 'active' : '';

$a = function (string $href, string $key, string $label) use ($mk): string {
  $cls = $mk($key);
  $style = $cls ? 'background:rgba(36,91,255,.22);color:#fff;' : '';
  return '<a href="'.e($href).'" class="d-flex align-items-center gap-2 px-3 py-2 rounded-4 text-decoration-none mb-1 '.$cls.'" style="color:#c9d4ff;'.$style.'">'.$label.'</a>';
};

echo $a($bp.'/rrhh', 'home', 'Dashboard');
echo $a($bp.'/rrhh/perfil', 'perfil', 'Mi perfil');
echo $a($bp.'/rrhh/skills', 'skills', 'Skills (porcentajes)');
echo '<hr style="border-color:rgba(255,255,255,.12)">';
echo $a($bp.'/rrhh/vacantes', 'vacantes', 'Vacantes (ligadas a empresa)');
echo $a($bp.'/rrhh/anuncios', 'anuncios', 'Anuncios');
echo $a($bp.'/rrhh/boosts', 'boosts', 'Boost');
echo $a($bp.'/rrhh/notificaciones', 'notifs', 'Notificaciones');
echo '<hr style="border-color:rgba(255,255,255,.12)">';
echo $a($bp.'/rrhh/ver?id='.(int)(AuthService::currentUserId() ?? 0), 'public', 'Ver perfil público');
