<?php
declare(strict_types=1);
/** @var array $it */
/** @var string $bp */

$it = is_array($it) ? $it : [];
$bp = (string)$bp;

$id        = (int)($it['id'] ?? 0);
$titulo    = (string)($it['titulo'] ?? 'Vacante');
$empresa   = (string)($it['empresa_nombre'] ?? 'Empresa');
$ubicacion = (string)($it['ubicacion'] ?? '');
$modalidad = (string)($it['modalidad'] ?? '');
$tipoEmpleo= (string)($it['tipo_empleo'] ?? '');
$matchCount= (int)($it['match_count'] ?? 0);
$isIdeal   = ((int)($it['is_ideal'] ?? 0) === 1);

$empresaRating = (float)($it['empresa_rating'] ?? 0);
$empresaVerif  = ((int)($it['empresa_verificada'] ?? 0) === 1);

// ✅ Ruta de detalle EXACTA igual a vacante_card:
$url = $bp . '/vacantes/ver?id=' . $id;

$icon = function(string $name): string {
  return match ($name) {
    'sparkle' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l1.3 5.2L18 9l-4.7 1.8L12 16l-1.3-5.2L6 9l4.7-1.8L12 2z"/><path d="M19 14l.7 2.7L22 18l-2.3 1.3L19 22l-.7-2.7L16 18l2.3-1.3L19 14z"/></svg>',
    'bolt'    => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M13 2L3 14h7l-1 8 10-12h-7l1-8z"/></svg>',
    'star'    => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l2.5 5 5.5.8-4 3.9.9 5.5L12 15.8 7.1 17.2l.9-5.5-4-3.9 5.5-.8L12 2z"/></svg>',
    'check'   => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M20 6L9 17l-5-5"/></svg>',
    'pin'     => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 21s7-4.5 7-11a7 7 0 0 0-14 0c0 6.5 7 11 7 11z"/><path d="M12 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/></svg>',
    'layers'  => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l9 5-9 5-9-5 9-5z"/><path d="M3 12l9 5 9-5"/><path d="M3 17l9 5 9-5"/></svg>',
    'briefcase'=> '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M10 6V5a2 2 0 0 1 2-2h0a2 2 0 0 1 2 2v1"/><path d="M4 7h16v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V7z"/></svg>',
    'arrow'   => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M9 18l6-6-6-6"/><path d="M15 12H4"/></svg>',
    default   => '',
  };
};

// Chips: patrocinada/top/empresa
$insLabel = 'Empresa';
$insVar   = 'neutral';
$insIcon  = 'sparkle';

if ($isIdeal) {
  $insLabel = 'Patrocinada';
  $insVar   = 'warn';
  $insIcon  = 'bolt';
} elseif ($empresaRating >= 4.5) {
  $insLabel = 'Top';
  $insVar   = 'success';
  $insIcon  = 'sparkle';
}

$subParts = [];
if ($ubicacion !== '') $subParts[] = ['pin', $ubicacion];
if ($modalidad !== '') $subParts[] = ['layers', $modalidad];
if ($tipoEmpleo !== '') $subParts[] = ['briefcase', $tipoEmpleo];

$miniId = 'vacmini_' . $id;
?>

<style>
/* Encapsulado para no romper otras vistas; “feel” como vacante_card */
#<?= htmlspecialchars($miniId) ?>.vac-mini{
  border:1px solid #e8eefc;
  border-radius:14px;
  background:#fff;
  box-shadow: 0 6px 18px rgba(15, 30, 80, .06);
  padding:12px;
}
#<?= htmlspecialchars($miniId) ?> .vm-row{
  display:flex;
  justify-content:space-between;
  align-items:flex-start;
  gap:10px;
}
#<?= htmlspecialchars($miniId) ?> .vm-title{
  font-weight:800;
  font-size:.92rem;
  line-height:1.2;
  margin:0;
}
#<?= htmlspecialchars($miniId) ?> .vm-title a{
  text-decoration:none;
  color:#0b1220;
}
#<?= htmlspecialchars($miniId) ?> .vm-title a:hover{ text-decoration:underline; }
#<?= htmlspecialchars($miniId) ?> .vm-company{
  color:#5b6b86;
  font-size:.82rem;
  margin-top:4px;
  display:flex;
  flex-wrap:wrap;
  gap:8px;
  align-items:center;
}
#<?= htmlspecialchars($miniId) ?> .vm-sub{
  color:#5b6b86;
  font-size:.82rem;
  display:flex;
  flex-wrap:wrap;
  gap:12px;
  margin-top:6px;
}
#<?= htmlspecialchars($miniId) ?> .vm-ico svg{
  width:15px;height:15px;
  display:block;
  fill:none;
  stroke:currentColor;
  stroke-width:2;
  stroke-linecap:round;
  stroke-linejoin:round;
}
#<?= htmlspecialchars($miniId) ?> .vm-chip{
  display:inline-flex;
  align-items:center;
  gap:6px;
  padding:6px 10px;
  border-radius:999px;
  border:1px solid #e8eefc;
  background:#f7f9ff;
  color:#0b1220;
  font-size:.78rem;
  font-weight:800;
  line-height:1;
  white-space:nowrap;
}
#<?= htmlspecialchars($miniId) ?> .vm-chip--neutral{ background:#f7f9ff; }
#<?= htmlspecialchars($miniId) ?> .vm-chip--success{ background:#ecfdf5; color:#065f46; border-color:#d1fae5; }
#<?= htmlspecialchars($miniId) ?> .vm-chip--warn{ background:#fffbeb; color:#92400e; border-color:#fde68a; }
#<?= htmlspecialchars($miniId) ?> .vm-chip--info{ background:#eef3ff; color:#1d4ed8; }
#<?= htmlspecialchars($miniId) ?> .vm-actions{
  display:flex;
  gap:10px;
  margin-top:10px;
  align-items:center;
}
#<?= htmlspecialchars($miniId) ?> .vm-btn{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding:8px 10px;
  border-radius:999px;
  border:1px solid #e8eefc;
  background:#fff;
  color:#0b1220;
  font-weight:900;
  font-size:.82rem;
  text-decoration:none;
  white-space:nowrap;
}
#<?= htmlspecialchars($miniId) ?> .vm-btn:hover{
  background:#f7f9ff;
  border-color:#d7e2ff;
}
</style>

<div id="<?= htmlspecialchars($miniId) ?>" class="vac-mini">

  <div class="vm-row">
    <h3 class="vm-title">
      <a href="<?= htmlspecialchars($url) ?>">
        <?= htmlspecialchars($titulo) ?>
      </a>
    </h3>

    <span class="vm-chip vm-chip--<?= htmlspecialchars($insVar) ?>">
      <span class="vm-ico"><?= $icon($insIcon) ?></span>
      <span><?= htmlspecialchars($insLabel) ?></span>
    </span>
  </div>

  <div class="vm-company">
    <span><?= htmlspecialchars($empresa) ?></span>

    <?php if ($empresaVerif): ?>
      <span class="vm-chip vm-chip--info">
        <span class="vm-ico"><?= $icon('check') ?></span>
        <span>Verificada</span>
      </span>
    <?php endif; ?>

    <?php if ($empresaRating > 0): ?>
      <span class="vm-chip vm-chip--neutral" title="Puntuación de empresa">
        <span class="vm-ico"><?= $icon('star') ?></span>
        <span><?= htmlspecialchars(number_format($empresaRating, 1)) ?></span>
      </span>
    <?php endif; ?>
  </div>

  <?php if (!empty($subParts)): ?>
    <div class="vm-sub">
      <?php foreach ($subParts as [$ico, $txt]): ?>
        <span>
          <span class="vm-ico" style="color:#5b6b86;opacity:.9;display:inline-flex;vertical-align:-3px;margin-right:6px;">
            <?= $icon((string)$ico) ?>
          </span>
          <?= htmlspecialchars((string)$txt) ?>
        </span>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <div class="vm-actions">
    <?php if ($matchCount > 0): ?>
      <span class="vm-chip vm-chip--success">
        <span class="vm-ico"><?= $icon('check') ?></span>
        <span>Match</span>
      </span>
    <?php endif; ?>

    <span style="flex:1 1 auto;"></span>

    <!-- ✅ Igual que vacante_card: /vacantes/ver?id= -->
    <a class="vm-btn" href="<?= htmlspecialchars($url) ?>" aria-label="Ver detalle">
      <span>Detalle</span>
      <span class="vm-ico"><?= $icon('arrow') ?></span>
    </a>
  </div>

</div>
