<?php
/** @var array $user */
/** @var array $perfil */
/** @var ?array $cv */
/** @var array $selectedCats */
/** @var int $completion */
/** @var array $checks */
/** @var array $reco */

$bp = base_path();

// Defaults defensivos (evita warnings si el controller no manda algo)
$user = is_array($user ?? null) ? $user : [];
$perfil = is_array($perfil ?? null) ? $perfil : [];
$cv = is_array($cv ?? null) ? $cv : null;

$selectedCats = is_array($selectedCats ?? null) ? $selectedCats : [];
$completion = (int)($completion ?? 0);
$checks = is_array($checks ?? null) ? $checks : [];
$reco = is_array($reco ?? null) ? $reco : [];

function badge_bool(bool $ok): string {
  return $ok
    ? '<span class="badge text-bg-success">OK</span>'
    : '<span class="badge text-bg-warning text-dark">Pendiente</span>';
}

$uid = (int)($user['id'] ?? 0);

$hasCats = !empty($checks['categorias']);
$hasTitulo = !empty($checks['titulo_profesional']);
$hasBio = !empty($checks['bio']);
$hasUbic = !empty($checks['ubicacion']);
$hasLinkedin = !empty($checks['linkedin']); // si ya lo quitaste del sistema, podés eliminar esta fila en checklist
$hasPortfolio = !empty($checks['portfolio']);
$hasCv = !empty($checks['cv']);

$completion = max(0, min(100, $completion));

?>
<div class="container py-3">

  <div class="app-card p-4 mb-3">
    <div class="d-flex flex-wrap align-items-start justify-content-between gap-2">
      <div>
        <h2 class="mb-1">Panel del postulante</h2>
        <div class="text-muted small">Tu centro de control: perfil, categorías, postulaciones y recomendaciones.</div>
      </div>
      <div class="d-flex flex-wrap gap-2">
        <a class="btn btn-outline-primary btn-sm" href="<?= e($bp) ?>/postulante/perfil">Editar perfil</a>
        <a class="btn btn-outline-primary btn-sm" href="<?= e($bp) ?>/postulante/roles">Editar categorías</a>
        <a class="btn btn-primary btn-sm" href="<?= e($bp) ?>/postulante/postulaciones">Mis postulaciones</a>
      </div>
    </div>
  </div>

  <div class="row g-3">

    <!-- Col izquierda: estado del perfil -->
    <div class="col-12 col-lg-4">
      <div class="app-card p-4 h-100">
        <div class="d-flex align-items-center justify-content-between">
          <div class="fw-semibold">Completitud del perfil</div>
          <span class="badge text-bg-primary"><?= (int)$completion ?>%</span>
        </div>

        <div class="progress mt-3" role="progressbar" aria-valuenow="<?= (int)$completion ?>" aria-valuemin="0" aria-valuemax="100">
          <div class="progress-bar" style="width: <?= (int)$completion ?>%"></div>
        </div>

        <?php if (!$hasCats): ?>
          <div class="alert alert-warning mt-3 mb-0">
            <div class="fw-semibold">Acción requerida</div>
            <div class="small">Sin categorías no hay match real, ni recomendaciones, ni boosts relevantes.</div>
            <div class="mt-2">
              <a class="btn btn-sm btn-dark" href="<?= e($bp) ?>/postulante/roles">Seleccionar categorías</a>
            </div>
          </div>
        <?php endif; ?>

        <div class="mt-3 small text-muted">Checklist</div>
        <ul class="list-unstyled mt-2 mb-0 small">
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>Categorías</span><?= badge_bool($hasCats) ?>
          </li>
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>Título profesional</span><?= badge_bool($hasTitulo) ?>
          </li>
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>Bio</span><?= badge_bool($hasBio) ?>
          </li>
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>Ubicación</span><?= badge_bool($hasUbic) ?>
          </li>
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>Portfolio</span><?= badge_bool($hasPortfolio) ?>
          </li>
          <li class="d-flex align-items-center justify-content-between py-1">
            <span>CV</span><?= badge_bool($hasCv) ?>
          </li>
        </ul>

        <hr class="my-3"/>

        <div class="d-grid gap-2">
          <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/postulante/roles">Editar mis categorías</a>
          <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/p?id=<?= $uid ?>">Ver mi perfil público</a>
        </div>

        <div class="small text-muted mt-3">
          Consejo: el “match” depende fuertemente de categorías + bio + título.
        </div>
      </div>
    </div>

    <!-- Col derecha: categorías + recomendaciones -->
    <div class="col-12 col-lg-8">
      <div class="app-card p-4 h-100">

        <div class="d-flex align-items-center justify-content-between gap-2">
          <div class="fw-semibold">Mis categorías (match)</div>
          <a class="btn btn-sm btn-outline-primary" href="<?= e($bp) ?>/postulante/roles">Editar</a>
        </div>

        <?php if (empty($selectedCats)): ?>
          <div class="text-muted small mt-3">
            Aún no has seleccionado categorías. Esto reduce el match y la calidad de recomendaciones.
          </div>
        <?php else: ?>
          <div class="d-flex flex-wrap gap-2 mt-3">
            <?php foreach ($selectedCats as $c): ?>
              <span class="badge text-bg-secondary"><?= e((string)($c['nombre'] ?? '')) ?></span>
            <?php endforeach; ?>
          </div>
          <div class="small text-muted mt-2">
            Estas categorías se usan para recomendaciones y segmentación (boost/publicidad).
          </div>
        <?php endif; ?>

        <hr class="my-4"/>

        <div class="d-flex align-items-center justify-content-between gap-2">
          <div class="fw-semibold">Vacantes recomendadas</div>
          <a class="btn btn-sm btn-outline-secondary" href="<?= e($bp) ?>/feed">Ir al feed</a>
        </div>

        <?php if (empty($reco)): ?>
          <div class="text-muted small mt-3">
            No hay recomendaciones aún. Completa categorías y perfil para mejorar el match.
            <div class="mt-2">
              <a class="btn btn-sm btn-dark" href="<?= e($bp) ?>/postulante/roles">Seleccionar categorías</a>
            </div>
          </div>
        <?php else: ?>
          <div class="list-group mt-3">
            <?php foreach ($reco as $v): ?>
              <?php
                $vid = (int)($v['id'] ?? 0);
                $url = $bp . '/vacantes/ver?id=' . $vid;
              ?>
              <a class="list-group-item list-group-item-action border rounded-3 mb-2"
                 style="border-color:#e8eefc;"
                 href="<?= e($url) ?>">
                <div class="d-flex align-items-start justify-content-between gap-2">
                  <div>
                    <div class="fw-semibold"><?= e((string)($v['titulo'] ?? 'Vacante')) ?></div>
                    <div class="small text-muted">
                      <?= e((string)($v['empresa_nombre'] ?? 'Empresa')) ?>
                      <?php if (!empty($v['ubicacion'])): ?> • <?= e((string)$v['ubicacion']) ?><?php endif; ?>
                    </div>
                    <?php if (!empty($v['categorias_match'])): ?>
                      <div class="small text-muted mt-1">Match: <?= e((string)$v['categorias_match']) ?></div>
                    <?php endif; ?>
                  </div>

                  <?php if (!empty($v['is_ideal']) && (int)$v['is_ideal'] === 1): ?>
                    <span class="badge text-bg-warning text-dark">Ideal</span>
                  <?php endif; ?>
                </div>
              </a>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>

      </div>
    </div>

  </div>

  <div class="app-card p-4 mt-3">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
      <div>
        <div class="fw-semibold">Herramientas (módulos monetizables)</div>
        <div class="small text-muted">Dejamos lista la sección para agregar utilidades premium.</div>
      </div>
    </div>

    <div class="row g-2 mt-2">
      <div class="col-12 col-md-6 col-lg-3">
        <div class="p-3 rounded border h-100" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold">Optimizar CV</div>
          <div class="small text-muted mt-1">Revisión ATS + mejoras.</div>
          <div class="mt-2"><span class="badge text-bg-secondary">Próximamente</span></div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div class="p-3 rounded border h-100" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold">Carta de presentación</div>
          <div class="small text-muted mt-1">Por vacante, con guía.</div>
          <div class="mt-2"><span class="badge text-bg-secondary">Próximamente</span></div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div class="p-3 rounded border h-100" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold">Simulador de entrevista</div>
          <div class="small text-muted mt-1">Preguntas + scoring.</div>
          <div class="mt-2"><span class="badge text-bg-secondary">Próximamente</span></div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div class="p-3 rounded border h-100" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold">Boost / Visibilidad</div>
          <div class="small text-muted mt-1">Más exposición a empresas.</div>
          <div class="mt-2"><span class="badge text-bg-secondary">Próximamente</span></div>
        </div>
      </div>
    </div>
  </div>

</div>
