<?php
/** @var array $user */
/** @var array $perfil */
/** @var ?array $cv */
/** @var string $csrf */
/** @var ?string $error */
/** @var ?string $ok */
/** @var ?array $cats */
/** @var ?array $catSel */

$bp = base_path();

$user = is_array($user ?? null) ? $user : [];
$perfil = is_array($perfil ?? null) ? $perfil : [];

$cats = is_array($cats ?? null) ? $cats : [];
$catSel = is_array($catSel ?? null) ? $catSel : [];

$publicUrl = $bp . '/p?id=' . (int)($user['id'] ?? 0);

$nombre = trim((string)($user['nombre'] ?? ''));
$titulo = trim((string)($perfil['titulo_profesional'] ?? ''));
$ubic   = trim((string)($perfil['ubicacion'] ?? ''));
$bioHtml = trim((string)($perfil['bio'] ?? '')); // guardamos HTML del editor
$retosRaw = trim((string)($perfil['retos'] ?? '')); // ideal: columna perfil.retros (o json) - si no existe aún, no rompe
?>
<div class="container py-4">

  <div class="app-card p-4 mb-3">
    <div class="d-flex align-items-start justify-content-between gap-3">
      <div>
        <h4 class="mb-1">Mi perfil</h4>
        <div class="text-muted small">Ordená tu perfil para que empresas entiendan tu valor en 15 segundos.</div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/feed">Volver</a>
        <a class="btn btn-outline-primary btn-sm" href="<?= e($publicUrl) ?>" target="_blank" rel="noopener noreferrer">Ver público</a>
      </div>
    </div>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger mt-3 mb-0"><?= e((string)$error) ?></div>
    <?php endif; ?>
    <?php if (!empty($ok)): ?>
      <div class="alert alert-success mt-3 mb-0"><?= e((string)$ok) ?></div>
    <?php endif; ?>
  </div>

  <div class="row g-3">

    <div class="col-12 col-lg-7">
      <div class="app-card p-4">
        <h5 class="mb-3">Datos del perfil</h5>

        <form method="post" action="<?= e($bp) ?>/postulante/perfil" id="perfilForm">
          <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">

          <div class="row g-3">
            <div class="col-12">
              <label class="form-label">Nombre público</label>
              <input class="form-control" name="nombre" value="<?= e((string)($user['nombre'] ?? '')) ?>" placeholder="Tu nombre completo">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Teléfono</label>
              <input class="form-control" name="telefono" value="<?= e((string)($perfil['telefono'] ?? '')) ?>" placeholder="+506 ...">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Ubicación</label>
              <input class="form-control" name="ubicacion" value="<?= e((string)($perfil['ubicacion'] ?? '')) ?>" placeholder="Alajuela, CR">
            </div>

            <div class="col-12">
              <label class="form-label">Título profesional</label>
              <input class="form-control" name="titulo_profesional" value="<?= e((string)($perfil['titulo_profesional'] ?? '')) ?>" placeholder="Ej: Albañil / Desarrollador PHP / RRHH">
              <div class="form-text">Que sea directo. Rol + especialidad (si aplica).</div>
            </div>

            <div class="col-12">
              <label class="form-label">Categorías / Roles</label>
              <?php if (empty($cats)): ?>
                <div class="text-muted small">Aún no hay catálogo de categorías cargado.</div>
              <?php else: ?>
                <select class="form-select" name="categorias_ids[]" multiple size="8">
                  <?php foreach ($cats as $c): ?>
                    <?php
                      $cid = (int)($c['id'] ?? 0);
                      $cn  = (string)($c['nombre'] ?? '');
                      if ($cid <= 0 || $cn === '') continue;
                      $sel = in_array($cid, $catSel, true) ? 'selected' : '';
                    ?>
                    <option value="<?= $cid ?>" <?= $sel ?>><?= e($cn) ?></option>
                  <?php endforeach; ?>
                </select>
                <div class="form-text">Esto define tu match en el feed y recomendaciones.</div>
              <?php endif; ?>
            </div>

            <div class="col-12">
              <label class="form-label">Bio (editor)</label>

              <div class="border rounded-3" style="border-color:#e8eefc;background:#fff;">
                <div class="d-flex flex-wrap gap-2 p-2 border-bottom" style="border-color:#e8eefc;">
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="bold"><b>B</b></button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="italic"><i>I</i></button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="h3">H</button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="ul">• Lista</button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="ol">1. Lista</button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="quote">“ Cita</button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" data-ed="link">Link</button>
                  <span class="ms-auto text-muted small align-self-center">Tip: 3–6 bullets con logros reales</span>
                </div>

                <div id="bioEditor"
                     contenteditable="true"
                     class="p-3"
                     style="min-height:170px;outline:none;line-height:1.45;">
                  <?= $bioHtml !== '' ? $bioHtml : '<p>• Experiencia / especialidad</p><p>• Logro medible</p><p>• Herramientas / stack</p>' ?>
                </div>
              </div>

              <input type="hidden" name="bio" id="bioHidden" value="">

              <div class="form-text">Tu bio pública se renderiza con formato (listas/títulos). Sin LinkedIn.</div>
            </div>

            <div class="col-12">
              <label class="form-label">Portafolio (URL)</label>
              <input class="form-control" name="portfolio_url" value="<?= e((string)($perfil['portfolio_url'] ?? '')) ?>" placeholder="https://...">
              <div class="form-text">Opcional. Se muestra como botón en el perfil público.</div>
            </div>

            <div class="col-12">
              <label class="form-label">Retos asumidos (del postulante)</label>
              <textarea class="form-control" rows="5" name="retos" placeholder="Un reto por línea. Ej: Conseguir trabajo estable, mejorar ingresos, especializarme..."><?= e($retosRaw) ?></textarea>
              <div class="form-text">Esto lo escribe el postulante. Se muestra como lista pública.</div>
            </div>

            <div class="col-12 d-flex justify-content-end">
              <button class="btn btn-primary" type="submit">Guardar cambios</button>
            </div>
          </div>
        </form>

      </div>
    </div>

    <div class="col-12 col-lg-5">
      <div class="app-card p-4 mb-3">
        <h5 class="mb-3">Vista pública (resumen)</h5>

        <div class="p-3 rounded border" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold"><?= e($nombre !== '' ? $nombre : 'Tu nombre') ?></div>
          <div class="small text-muted">
            <?= e($titulo !== '' ? $titulo : 'Tu título profesional') ?>
            <?php if ($ubic !== ''): ?> • <?= e($ubic) ?><?php endif; ?>
          </div>

          <div class="small text-muted mt-2">Tu bio tendrá el mismo formato (listas/títulos) que escribas en el editor.</div>

          <div class="d-flex flex-wrap gap-2 mt-3">
            <?php if (!empty($catSel)): ?>
              <span class="badge text-bg-primary"><?= count($catSel) ?> rol(es)</span>
            <?php else: ?>
              <span class="badge text-bg-light" style="border:1px solid #e8eefc;">Sin roles</span>
            <?php endif; ?>
            <?php if (is_array($cv) && (int)($cv['id'] ?? 0) > 0): ?>
              <span class="badge text-bg-success">CV listo</span>
            <?php else: ?>
              <span class="badge text-bg-light" style="border:1px solid #e8eefc;">CV pendiente</span>
            <?php endif; ?>
          </div>

          <div class="small text-muted mt-2">
            Link público:
            <a href="<?= e($publicUrl) ?>" class="text-decoration-none"><?= e($publicUrl) ?></a>
          </div>
        </div>
      </div>

      <div class="app-card p-4">
        <h5 class="mb-3">CV</h5>

        <?php if ($cv): ?>
          <div class="alert alert-success">
            <div class="fw-semibold">CV cargado</div>
            <div class="small text-muted"><?= e((string)$cv['original_name']) ?> (<?= (int)$cv['size_bytes'] ?> bytes)</div>
          </div>

          <form method="post" action="<?= e($bp) ?>/postulante/cv/eliminar" class="d-flex justify-content-end">
            <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">
            <button class="btn btn-outline-danger btn-sm" type="submit">Eliminar CV activo</button>
          </form>
        <?php else: ?>
          <div class="alert alert-warning">
            Aún no has subido tu CV. Recomendado para postular.
          </div>
        <?php endif; ?>

        <form method="post" action="<?= e($bp) ?>/postulante/cv/subir" enctype="multipart/form-data" class="mt-3">
          <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">

          <label class="form-label">Subir CV (PDF/DOC/DOCX, máx 5MB)</label>
          <input class="form-control" type="file" name="cv" accept=".pdf,.doc,.docx" required>

          <div class="d-grid mt-3">
            <button class="btn btn-primary" type="submit">Subir CV</button>
          </div>

          <div class="small text-muted mt-2">
            Este CV será el “activo” que verán las empresas en tus postulaciones.
          </div>
        </form>
      </div>
    </div>

  </div>
</div>

<script>
(function(){
  const form = document.getElementById('perfilForm');
  const editor = document.getElementById('bioEditor');
  const hidden = document.getElementById('bioHidden');

  function cmd(name, value=null){
    document.execCommand(name, false, value);
    editor.focus();
  }

  document.querySelectorAll('[data-ed]').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const a = btn.getAttribute('data-ed');
      if (a === 'bold') return cmd('bold');
      if (a === 'italic') return cmd('italic');
      if (a === 'h3') return cmd('formatBlock', 'h3');
      if (a === 'ul') return cmd('insertUnorderedList');
      if (a === 'ol') return cmd('insertOrderedList');
      if (a === 'quote') return cmd('formatBlock', 'blockquote');
      if (a === 'link') {
        const url = prompt('URL (https://...)');
        if (!url) return;
        cmd('createLink', url);
      }
    });
  });

  form.addEventListener('submit', ()=>{
    // guardamos HTML tal cual para render público (tu backend decide si sanitiza)
    hidden.value = editor.innerHTML.trim();
  });
})();
</script>
