<?php
/** @var array $items */
/** @var string|null $error */
/** @var string $csrf */

$badge = function (string $estado): string {
  return match ($estado) {
    'enviada'       => 'secondary',
    'vista'         => 'info',
    'preseleccion'  => 'success',
    'rechazada'     => 'danger',
    default         => 'light',
  };
};

$bp = base_path();
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Mis postulaciones</h3>
      <div class="text-muted small">Historial de vacantes a las que aplicaste y su estado.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/feed') ?>">Volver</a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Vacante</th>
              <th>Empresa</th>
              <th>Ubicación</th>
              <th>Estado</th>
              <th>Aplicado</th>
              <th class="text-end">Acciones</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($items)): ?>
              <tr>
                <td colspan="7" class="text-center text-muted py-4">Aún no has postulado a ninguna vacante.</td>
              </tr>
            <?php else: ?>
              <?php foreach ($items as $it): ?>
                <?php
                  $pid   = (int)($it['id'] ?? 0);
                  $vid   = (int)($it['vacante_id'] ?? 0);
                  $titulo = (string)($it['titulo'] ?? ('Vacante #' . $vid));
                  $empresa = (string)($it['empresa_email'] ?? '—');
                  $ubic = (string)($it['ubicacion'] ?? '—');
                  $estado = (string)($it['postulacion_estado'] ?? 'enviada');
                  $creado = (string)($it['postulacion_creado_en'] ?? '');
                ?>
                <tr>
                  <td class="text-muted">#<?= $pid ?></td>
                  <td class="fw-semibold"><?= htmlspecialchars($titulo) ?></td>
                  <td><?= htmlspecialchars($empresa) ?></td>
                  <td><?= htmlspecialchars($ubic) ?></td>
                  <td>
                    <span class="badge text-bg-<?= $badge($estado) ?>"><?= htmlspecialchars($estado) ?></span>
                  </td>
                  <td class="small text-muted"><?= htmlspecialchars($creado) ?></td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-outline-primary" href="<?= htmlspecialchars($bp . '/vacantes/ver?id=' . $vid) ?>">
                      Ver vacante
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
