<?php
/** @var array $cats */
/** @var array $sel */
/** @var string $csrf */
$bp = base_path();
$selSet = array_flip(array_map('intval', $sel ?? []));
?>
<div class="container">
  <div class="row g-3">
    <div class="col-12">
      <div class="app-card p-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
          <div>
            <h3 class="mb-1">Mis roles / intereses</h3>
            <div class="text-muted small">Seleccioná al menos 1 categoría para mejorar el match con vacantes y habilitar herramientas/boost.</div>
          </div>
          <a class="btn btn-outline-light" href="<?= e($bp) ?>/postulante/panel">Volver al panel</a>
        </div>

        <hr class="my-4"/>

        <form method="post" action="<?= e($bp) ?>/postulante/roles">
          <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">

          <div class="row g-2 mb-3">
            <div class="col-md-6">
              <input id="roleSearch" class="form-control" placeholder="Buscar (ej: ventas, soporte, backend, call center)..." autocomplete="off">
            </div>
            <div class="col-md-6 d-flex gap-2 justify-content-md-end">
              <button class="btn btn-outline-light" type="button" id="btnClear">Limpiar</button>
              <button class="btn btn-primary" type="submit">Guardar selección</button>
            </div>
          </div>

          <?php if (!$cats): ?>
            <div class="alert alert-warning mb-0">No hay categorías disponibles aún.</div>
          <?php else: ?>
            <div class="row g-2" id="rolesGrid">
              <?php foreach ($cats as $c):
                $id = (int)($c['id'] ?? 0);
                $nombre = (string)($c['nombre'] ?? '');
                $codigo = (string)($c['codigo'] ?? '');
                $parent = (int)($c['parent_id'] ?? 0);
                $checked = isset($selSet[$id]);
                $hay = $nombre !== '';
              ?>
                <?php if ($hay): ?>
                <div class="col-12 col-md-6 col-lg-4 role-item" data-text="<?= e(mb_strtolower($nombre.' '.$codigo)) ?>">
                  <label class="d-flex align-items-start gap-2 p-3 rounded border border-white-10 bg-dark-2">
                    <input class="form-check-input mt-1" type="checkbox" name="roles[]" value="<?= $id ?>" <?= $checked ? 'checked' : '' ?>>
                    <div class="flex-grow-1">
                      <div class="fw-semibold"><?= e($nombre) ?></div>
                      <div class="small text-muted">
                        <?= $codigo ? e($codigo) : 'Categoría' ?>
                        <?= $parent ? ' • Subcategoría' : '' ?>
                      </div>
                    </div>
                  </label>
                </div>
                <?php endif; ?>
              <?php endforeach; ?>
            </div>

            <div class="small text-muted mt-3">
              Tip: entre más precisa tu selección, mejor se ajustan las recomendaciones y segmentaciones.
            </div>
          <?php endif; ?>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  const q = document.getElementById('roleSearch');
  const grid = document.getElementById('rolesGrid');
  const btnClear = document.getElementById('btnClear');

  function norm(s){ return (s||'').toString().trim().toLowerCase(); }

  function apply(){
    const term = norm(q.value);
    if(!grid) return;
    const items = grid.querySelectorAll('.role-item');
    items.forEach(it=>{
      const t = it.getAttribute('data-text') || '';
      it.style.display = (!term || t.includes(term)) ? '' : 'none';
    });
  }

  if(q) q.addEventListener('input', apply);
  if(btnClear) btnClear.addEventListener('click', ()=>{
    if(q) q.value='';
    apply();
  });
})();
</script>
