<?php declare(strict_types=1);
/** @var string $csrf */
/** @var array $items */
$bp = base_path();
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
      <div>
        <div class="h5 mb-1">Anuncios</div>
        <div class="text-muted small">Publica anuncios (servicios, ofertas, comunicados). No son vacantes.</div>
      </div>
      <a class="btn btn-primary btn-sm" href="<?= e($bp) ?>/rrhh/anuncios/editar">Nuevo anuncio</a>
    </div>

    <hr>

    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Título</th>
            <th>Tipo</th>
            <th>Estado</th>
            <th>Publicado</th>
            <th style="width:160px;">Acción</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($items ?? []) as $it): ?>
          <tr>
            <td><?= e((string)$it['titulo']) ?></td>
            <td><?= e((string)$it['tipo']) ?></td>
            <td><?= e((string)$it['estado']) ?></td>
            <td class="text-muted small"><?= e((string)($it['publicado_en'] ?? '—')) ?></td>
            <td>
              <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/rrhh/anuncios/editar?id=<?= (int)$it['id'] ?>">Editar</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>
