<?php
declare(strict_types=1);
/** @var array $p */

$bp = base_path();

$nombre = (string)($p['nombre'] ?? 'Profesional RRHH');
$titulo = (string)($p['titular'] ?? ($p['titulo'] ?? ''));
$ubic   = (string)($p['ubicacion'] ?? '');
$bio    = (string)($p['bio'] ?? '');

$ratingAvg   = (float)($p['rating_avg'] ?? ($p['rating']['avg'] ?? 0));
$ratingCount = (int)($p['rating_count'] ?? ($p['rating']['count'] ?? 0));

$foto = (string)($p['foto_path'] ?? '');
if ($foto !== '' && str_starts_with($foto, '/public/')) $foto = substr($foto, 7);
$fotoUrl = $foto !== '' ? ($bp . $foto) : '';

$skills = $p['skills'] ?? [];
if (!is_array($skills)) $skills = [];

$fmtStars = function(float $avg): string {
  $avg = max(0, min(5, $avg));
  $full = (int)floor($avg);
  $half = ($avg - $full) >= 0.5 ? 1 : 0;
  $empty = 5 - $full - $half;
  return str_repeat('★', $full) . ($half ? '☆' : '') . str_repeat('✩', $empty);
};

?>
<div class="container py-4" style="max-width:980px;">
  <div class="card border-0 shadow-sm">
    <div class="card-body p-4 p-md-5">

      <div class="d-flex gap-3 align-items-start">
        <div style="width:84px;height:84px;border-radius:18px;overflow:hidden;background:#f1f3f5;flex:0 0 auto;">
          <?php if ($fotoUrl !== ''): ?>
            <img src="<?= htmlspecialchars($fotoUrl) ?>" alt="Foto" style="width:100%;height:100%;object-fit:cover;">
          <?php endif; ?>
        </div>

        <div class="flex-grow-1">
          <div class="d-flex flex-wrap align-items-center gap-2">
            <h1 class="h4 mb-0"><?= htmlspecialchars($nombre) ?></h1>
            <span class="badge text-bg-dark">RRHH</span>
          </div>

          <?php if ($titulo !== ''): ?>
            <div class="text-muted mt-1"><?= htmlspecialchars($titulo) ?></div>
          <?php endif; ?>

          <div class="d-flex flex-wrap gap-3 mt-2 small text-muted">
            <?php if ($ubic !== ''): ?>
              <span><?= htmlspecialchars($ubic) ?></span>
            <?php endif; ?>
            <span title="Puntuación"><?= $fmtStars($ratingAvg) ?> <strong><?= number_format($ratingAvg, 1) ?></strong> <span class="text-muted">(<?= $ratingCount ?>)</span></span>
          </div>
        </div>
      </div>

      <hr class="my-4">

      <div class="row g-4">
        <div class="col-12 col-lg-7">
          <h2 class="h6 mb-2">Bio</h2>

          <?php if (trim($bio) === ''): ?>
            <div class="text-muted">Sin bio pública.</div>
          <?php else: ?>
            <div class="prose" style="line-height:1.65;">
              <?= $bio /* se asume sanitizado desde service */ ?>
            </div>
          <?php endif; ?>
        </div>

        <div class="col-12 col-lg-5">
          <h2 class="h6 mb-2">Skills</h2>

          <?php if (empty($skills)): ?>
            <div class="text-muted">Aún no hay skills públicas.</div>
          <?php else: ?>
            <div class="d-flex flex-column gap-3">
              <?php foreach ($skills as $s): ?>
                <?php
                  $cat = (string)($s['categoria'] ?? '');
                  $nom = (string)($s['nombre'] ?? '');
                  $pct = (int)($s['porcentaje'] ?? 0);
                  $pct = max(0, min(100, $pct));
                ?>
                <div>
                  <div class="d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fw-semibold"><?= htmlspecialchars($nom) ?></div>
                      <?php if ($cat !== ''): ?>
                        <div class="text-muted small"><?= htmlspecialchars($cat) ?></div>
                      <?php endif; ?>
                    </div>
                    <div class="fw-semibold"><?= $pct ?>%</div>
                  </div>
                  <div class="progress mt-2" role="progressbar" aria-valuenow="<?= $pct ?>" aria-valuemin="0" aria-valuemax="100" style="height:10px;border-radius:999px;">
                    <div class="progress-bar" style="width:<?= $pct ?>%;"></div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <hr class="my-4">

      <div class="d-flex flex-wrap gap-2">
        <a class="btn btn-outline-dark btn-sm" href="<?= htmlspecialchars($bp . '/feed') ?>">Volver al feed</a>
      </div>

    </div>
  </div>
</div>
