<?php
declare(strict_types=1);

/** @var int|null $empresaId */

$bp = base_path();
$empresaId = (int)($empresaId ?? 0);

?>
<div class="container py-4" style="max-width:1100px;">
  <div class="d-flex flex-wrap align-items-end justify-content-between gap-3 mb-3">
    <div>
      <h1 class="h4 mb-1" style="font-weight:900;">Vacantes</h1>
      <div class="text-muted">Gestión de vacantes para la empresa vinculada.</div>
    </div>

    <div class="d-flex gap-2">
      <a class="btn btn-outline-primary rounded-3" href="<?= e($bp) ?>/rrhh/perfil">Mi perfil</a>
      <a class="btn btn-outline-secondary rounded-3" href="<?= e($bp) ?>/rrhh/anuncios">Mis anuncios</a>
    </div>
  </div>

  <?php if ($empresaId <= 0): ?>
    <div class="card border-0 shadow-sm rounded-4">
      <div class="card-body p-4">
        <div class="d-flex align-items-start gap-3">
          <div style="width:48px;height:48px;border-radius:14px;background:#eef3ff;border:1px solid #e6ecff;display:flex;align-items:center;justify-content:center;font-weight:900;color:#245bff;">
            !
          </div>
          <div class="flex-grow-1">
            <div class="fw-bold mb-1">Necesitas vincular una empresa</div>
            <div class="text-muted" style="line-height:1.55;">
              Para publicar o administrar vacantes, este perfil RRHH debe estar vinculado a una empresa del sistema.
              Ve a tu perfil RRHH y selecciona la empresa en “Vinculación”.
            </div>

            <div class="mt-3 d-flex flex-wrap gap-2">
              <a class="btn btn-primary rounded-3" href="<?= e($bp) ?>/rrhh/perfil">Vincular empresa</a>
              <a class="btn btn-outline-primary rounded-3" href="<?= e($bp) ?>/rrhh/ver?id=<?= (int)($_SESSION['user_id'] ?? 0) ?>">Ver mi perfil público</a>
            </div>

            <div class="mt-4 p-3 rounded-3" style="background:#fbfcff;border:1px dashed #e6ecff;">
              <div class="small text-muted">
                Sugerencia: si una empresa quiere contratar tus servicios sin vincularte, eso se cubre con <b>Anuncios</b>.
                Vacantes requiere vínculo a empresa.
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  <?php else: ?>

    <div class="row g-3">
      <div class="col-12 col-lg-8">
        <div class="card border-0 shadow-sm rounded-4">
          <div class="card-body p-4">
            <div class="fw-bold mb-1">Acciones rápidas</div>
            <div class="text-muted mb-3">Empresa vinculada detectada. Ya puedes operar vacantes.</div>

            <div class="d-flex flex-wrap gap-2">
              <a class="btn btn-primary rounded-3" href="<?= e($bp) ?>/empresa/vacantes/nueva?modo=rrhh">
                Publicar vacante
              </a>
              <a class="btn btn-outline-primary rounded-3" href="<?= e($bp) ?>/empresa/vacantes?modo=rrhh">
                Ver / administrar vacantes
              </a>
              <a class="btn btn-outline-secondary rounded-3" href="<?= e($bp) ?>/empresa/postulaciones?modo=rrhh">
                Revisar postulaciones
              </a>
            </div>

            <hr class="my-4">

            <div class="fw-bold mb-2">Próximamente (módulos RRHH)</div>
            <div class="row g-2">
              <div class="col-12 col-md-6">
                <div class="p-3 rounded-4" style="border:1px solid #eef2ff;background:#fafbff;">
                  <div class="fw-semibold">Evaluación & Scoring</div>
                  <div class="small text-muted">Rubricas, notas, tags y recomendaciones automáticas por perfil.</div>
                </div>
              </div>
              <div class="col-12 col-md-6">
                <div class="p-3 rounded-4" style="border:1px solid #eef2ff;background:#fafbff;">
                  <div class="fw-semibold">Shortlists & Pipeline</div>
                  <div class="small text-muted">Estados del candidato: Nuevo, En revisión, Entrevista, Oferta, etc.</div>
                </div>
              </div>
              <div class="col-12 col-md-6">
                <div class="p-3 rounded-4" style="border:1px solid #eef2ff;background:#fafbff;">
                  <div class="fw-semibold">Plantillas de vacantes</div>
                  <div class="small text-muted">Duplicar vacantes, checklist legal y publicación asistida.</div>
                </div>
              </div>
              <div class="col-12 col-md-6">
                <div class="p-3 rounded-4" style="border:1px solid #eef2ff;background:#fafbff;">
                  <div class="fw-semibold">Boost (monetizable)</div>
                  <div class="small text-muted">Posicionamiento de vacantes/anuncios por categorías y alcance.</div>
                  <div class="mt-2">
                    <a class="btn btn-outline-primary btn-sm rounded-3" href="<?= e($bp) ?>/rrhh/boosts">Abrir Boost</a>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="col-12 col-lg-4">
        <div class="card border-0 shadow-sm rounded-4">
          <div class="card-body p-4">
            <div class="fw-bold mb-1">Estado de vinculación</div>
            <div class="text-muted mb-3">Conectado a empresa ID: <b><?= (int)$empresaId ?></b></div>

            <div class="p-3 rounded-4" style="border:1px solid #eef2ff;background:#fafbff;">
              <div class="small text-muted">Si necesitas cambiar la empresa vinculada:</div>
              <div class="mt-2">
                <a class="btn btn-outline-primary btn-sm rounded-3" href="<?= e($bp) ?>/rrhh/perfil">Editar vinculación</a>
              </div>
            </div>

            <hr class="my-4">

            <div class="fw-bold mb-2">Enfoque profesional</div>
            <div class="text-muted" style="line-height:1.55;">
              Este panel separa claramente:
              <b>Anuncios</b> (servicios RRHH sin empresa) y <b>Vacantes</b> (requiere empresa vinculada).
            </div>
          </div>
        </div>
      </div>
    </div>

  <?php endif; ?>
</div>
