<?php
declare(strict_types=1);

final class AdminMenu
{
    /**
     * Definición central del sidebar admin
     * Cada item puede requerir:
     * - permission (RBAC)
     * - module (plan/user module)
     */
    public static function items(): array
    {
        return [
            [
                'label' => 'Dashboard',
                'icon'  => 'bi-speedometer2',
                'route' => '/admin',
                'permission' => 'admin.access',
                'module' => 'admin_panel',
            ],

            [
                'label' => 'Planes',
                'icon'  => 'bi-box',
                'route' => '/admin/plans',
                'permission' => 'admin.plans.manage',
                'module' => 'admin_panel',
            ],

            [
                'label' => 'Módulos',
                'icon'  => 'bi-grid',
                'route' => '/admin/modules',
                'permission' => 'admin.modules.manage',
                'module' => 'admin_panel',
            ],

            [
                'label' => 'Roles',
                'icon'  => 'bi-shield-lock',
                'route' => '/admin/roles',
                'permission' => 'admin.rbac.manage',
                'module' => 'admin_panel',
            ],

            [
                'label' => 'Usuarios',
                'icon'  => 'bi-people',
                'route' => '/admin/users',
                'permission' => 'admin.rbac.manage',
                'module' => 'admin_panel',
            ],
            
            [
                'label' => 'Moderación',
                'icon'  => 'bi-flag',
                'route' => '/admin/moderacion/vacantes',
                'permission' => 'admin.moderation.manage',
                'module' => 'admin_panel',
            ],
            [
                'label' => 'Auditoría',
                'icon'  => 'bi-journal-text',
                'route' => '/admin/auditoria',
                'permission' => 'admin.audit.view',
                'module' => 'admin_panel',
            ],
        ];
    }
}
