<?php
declare(strict_types=1);

final class AdminModuleService
{
    public static function listAll(): array
    {
        $pdo = DB::pdo();

        $sql = "
            SELECT
                id,
                code,
                nombre,
                estado
            FROM modules
            ORDER BY id DESC
        ";

        return $pdo->query($sql)->fetchAll();
    }

    public static function find(int $id): ?array
    {
        $pdo = DB::pdo();

        $st = $pdo->prepare("
            SELECT id, code, nombre, estado
            FROM modules
            WHERE id = :id
            LIMIT 1
        ");
        $st->execute([':id' => $id]);

        $row = $st->fetch();
        return $row ?: null;
    }

    public static function create(string $code, string $nombre, string $estado): void
    {
        if ($code === '' || $nombre === '') {
            throw new ValidationException('Código y nombre son obligatorios.');
        }

        $pdo = DB::pdo();

        $st = $pdo->prepare("
            INSERT INTO modules (code, nombre, estado)
            VALUES (:c, :n, :e)
        ");
        $st->execute([
            ':c' => $code,
            ':n' => $nombre,
            ':e' => $estado,
        ]);
    }

    public static function update(int $id, string $code, string $nombre, string $estado): void
    {
        if ($code === '' || $nombre === '') {
            throw new ValidationException('Código y nombre son obligatorios.');
        }

        $pdo = DB::pdo();

        $st = $pdo->prepare("
            UPDATE modules
            SET code = :c,
                nombre = :n,
                estado = :e
            WHERE id = :id
        ");
        $st->execute([
            ':id' => $id,
            ':c'  => $code,
            ':n'  => $nombre,
            ':e'  => $estado,
        ]);
    }

    public static function delete(int $id): void
    {
        $pdo = DB::pdo();

        // seguridad mínima: no borrar módulos críticos
        $st = $pdo->prepare("SELECT code FROM modules WHERE id = :id");
        $st->execute([':id' => $id]);
        $row = $st->fetch();

        if (!$row) {
            throw new ValidationException('El módulo no existe.');
        }

        if ($row['code'] === 'admin_panel') {
            throw new ValidationException('No se puede eliminar el módulo admin_panel.');
        }

        $st = $pdo->prepare("DELETE FROM modules WHERE id = :id");
        $st->execute([':id' => $id]);
    }
}
