<?php
declare(strict_types=1);

final class EmpresaVacanteRolesController
{
    public static function form(Request $req, Response $res): Response
    {
        require_auth();
        $user = auth_user();

        // Seguridad: solo empresa (ajustá a tu lógica real si ya tenés helper)
        // if (($user['tipo'] ?? '') !== 'empresa') return $res->status(403)->html('Forbidden');

        $vacanteId = (int)($_GET['id'] ?? 0);
        if ($vacanteId <= 0) {
            return $res->status(400)->html('Vacante inválida');
        }

        // Verifica que la vacante sea de esta empresa
        $pdo = DB::pdo();
        $st = $pdo->prepare("SELECT id, empresa_user_id, titulo FROM vacantes WHERE id = :v LIMIT 1");
        $st->execute([':v' => $vacanteId]);
        $v = $st->fetch(PDO::FETCH_ASSOC);

        if (!$v || (int)$v['empresa_user_id'] !== (int)$user['id']) {
            return $res->status(403)->html('No autorizado');
        }

        $tree = CategoriaLaboralService::rolesTree();
        $selected = CategoriaLaboralService::vacanteRoleIds($vacanteId);
        $csrf = csrf_token();

        return $res->html(view('front/empresa_vacante_roles', [
            'tree' => $tree,
            'selected' => $selected,
            'csrf' => $csrf,
            'vacante' => $v,
        ]));
    }

    public static function save(Request $req, Response $res): Response
    {
        require_auth();
        csrf_verify();

        $user = auth_user();
        $vacanteId = (int)($_POST['vacante_id'] ?? 0);
        if ($vacanteId <= 0) {
            return $res->status(400)->html('Vacante inválida');
        }

        // Verifica ownership
        $pdo = DB::pdo();
        $st = $pdo->prepare("SELECT id, empresa_user_id FROM vacantes WHERE id = :v LIMIT 1");
        $st->execute([':v' => $vacanteId]);
        $v = $st->fetch(PDO::FETCH_ASSOC);
        if (!$v || (int)$v['empresa_user_id'] !== (int)$user['id']) {
            return $res->status(403)->html('No autorizado');
        }

        $roleIds = (array)($_POST['roles'] ?? []);
        CategoriaLaboralService::saveVacanteRoles($vacanteId, $roleIds);

        flash('success', 'Roles de la vacante actualizados.');
        return $res->redirect(base_path() . '/empresa/vacantes/roles?id=' . $vacanteId);
    }
}
