<?php
declare(strict_types=1);

final class PostulanteRolesController
{
    public static function form(Request $req, Response $res): Response
    {
        require_auth();
        $user = auth_user();
        $userId = (int)$user['id'];

        $tree = CategoriaLaboralService::rolesTree();
        $selected = CategoriaLaboralService::userRoleIds($userId);

        $csrf = csrf_token();

        return $res->html(view('front/postulante_roles', [
            'tree' => $tree,
            'selected' => $selected,
            'csrf' => $csrf,
            'userId' => $userId,
        ]));
    }

    public static function save(Request $req, Response $res): Response
    {
        require_auth();
        csrf_verify();

        $user = auth_user();
        $userId = (int)$user['id'];

        $roleIds = (array)($_POST['roles'] ?? []);
        CategoriaLaboralService::saveUserRoles($userId, $roleIds);

        flash('success', 'Tus roles/intereses fueron actualizados.');
        return $res->redirect(base_path() . '/postulante/roles');
    }
}
