<?php
declare(strict_types=1);

final class VacanteSlugService
{
    public static function ensureSlugForVacante(int $vacanteId, string $titulo, ?string $preferred = null): string
    {
        $base = $preferred !== null && trim($preferred) !== ''
            ? Seo::slugify($preferred)
            : Seo::slugify($titulo);

        if ($base === '') {
            $base = 'vacante-' . $vacanteId;
        }

        $pdo = DB::pdo();

        // si ya está libre, usarlo
        $slug = $base;
        $i = 0;

        while (true) {
            $st = $pdo->prepare("SELECT id FROM vacantes WHERE slug = :s AND id <> :id LIMIT 1");
            $st->execute(['s' => $slug, 'id' => $vacanteId]);
            $exists = (bool)$st->fetch(\PDO::FETCH_ASSOC);

            if (!$exists) break;

            $i++;
            $slug = $base . '-' . $i;
        }

        $pdo->prepare("UPDATE vacantes SET slug = :s WHERE id = :id")->execute([
            's'  => $slug,
            'id' => $vacanteId
        ]);

        return $slug;
    }

    public static function findBySlug(string $slug): ?array
    {
        $slug = trim($slug);
        if ($slug === '') return null;

        $pdo = DB::pdo();
        $st = $pdo->prepare("
          SELECT
            v.*,
            u.nombre AS empresa_nombre,
            u.email  AS empresa_email
          FROM vacantes v
          LEFT JOIN users u ON u.id = v.empresa_user_id
          WHERE v.slug = :s AND v.estado = 'publicada'
          LIMIT 1
        ");
        $st->execute(['s' => $slug]);

        $row = $st->fetch(\PDO::FETCH_ASSOC);
        return $row ?: null;
    }
}
