<?php
declare(strict_types=1);

final class PostulanteProfileService
{
    public static function getOrCreate(int $userId): array
    {
        $pdo = DB::pdo();

        $stmt = $pdo->prepare("SELECT * FROM postulante_perfiles WHERE user_id = :uid LIMIT 1");
        $stmt->execute(['uid' => $userId]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) return $row;

        $pdo->prepare("INSERT INTO postulante_perfiles (user_id) VALUES (:uid)")
            ->execute(['uid' => $userId]);

        $stmt = $pdo->prepare("SELECT * FROM postulante_perfiles WHERE user_id = :uid LIMIT 1");
        $stmt->execute(['uid' => $userId]);
        return (array)$stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function update(int $userId, array $data): void
    {
        $pdo = DB::pdo();

        // Perfil (tabla nueva)
        $sql = "UPDATE postulante_perfiles
                SET telefono = :telefono,
                    ubicacion = :ubicacion,
                    titulo_profesional = :titulo,
                    bio = :bio,
                    linkedin_url = :linkedin,
                    portfolio_url = :portfolio
                WHERE user_id = :uid";
        $pdo->prepare($sql)->execute([
            'telefono'  => self::nullableStr($data['telefono'] ?? null),
            'ubicacion' => self::nullableStr($data['ubicacion'] ?? null),
            'titulo'    => self::nullableStr($data['titulo_profesional'] ?? null),
            'bio'       => self::nullableStr($data['bio'] ?? null),
            'linkedin'  => self::nullableUrl($data['linkedin_url'] ?? null),
            'portfolio' => self::nullableUrl($data['portfolio_url'] ?? null),
            'uid'       => $userId,
        ]);

        // Nombre público (users.nombre ya existe)
        if (array_key_exists('nombre', $data)) {
            $nombre = trim((string)$data['nombre']);
            $pdo->prepare("UPDATE users SET nombre = :n WHERE id = :uid")
                ->execute(['n' => ($nombre === '' ? null : $nombre), 'uid' => $userId]);
        }
    }

    private static function nullableStr(mixed $v): ?string
    {
        $s = trim((string)($v ?? ''));
        return $s === '' ? null : $s;
    }

    private static function nullableUrl(mixed $v): ?string
    {
        $s = trim((string)($v ?? ''));
        if ($s === '') return null;
        if (!preg_match('~^https?://~i', $s)) return null;
        return $s;
    }
}
