<?php
declare(strict_types=1);

if (!function_exists('render_template')) {
    function render_template(string $templateRelativePath, array $data = []): string
    {
        $cfg = $GLOBALS['APP_CONFIG'] ?? [];
        $tplDir = $cfg['paths']['templates_dir'] ?? null;

        if (!$tplDir || !is_dir($tplDir)) {
            return '<h1>Error interno</h1>';
        }

        $rel = str_replace('\\', '/', $templateRelativePath);
        $rel = ltrim($rel, '/');

        if (str_contains($rel, '..')) {
            return '<h1>Acceso inválido</h1>';
        }

        $base = rtrim((string)$tplDir, '/');
        $full = $base . '/' . $rel;

        $realBase = realpath($base);
        $realFull = realpath($full);

        if ($realBase === false || $realFull === false || !str_starts_with($realFull, $realBase)) {
            $isDebug = (bool)($cfg['app']['debug'] ?? false);
            return $isDebug
                ? '<h1>Template inválido</h1><pre>' . (function_exists('e') ? e($rel) : htmlspecialchars($rel, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8')) . '</pre>'
                : '<h1>Error interno</h1>';
        }

        if (!is_file($realFull)) {
            $isDebug = (bool)($cfg['app']['debug'] ?? false);
            return $isDebug
                ? '<h1>Template no encontrado</h1><pre>' . (function_exists('e') ? e($rel) : htmlspecialchars($rel, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8')) . '</pre>'
                : '<h1>Template no encontrado</h1>';
        }

        extract($data, EXTR_SKIP);

        ob_start();
        require $realFull;
        return (string) ob_get_clean();
    }
}

if (!function_exists('base_path')) {
    function base_path(): string
    {
        $script = (string)($_SERVER['SCRIPT_NAME'] ?? '');
        $script = str_replace('\\', '/', $script);
        $dir = rtrim(str_replace('\\', '/', dirname($script)), '/');

        if ($dir === '' || $dir === '.' || $dir === '/') {
            return '';
        }
        return $dir;
    }
}

if (!function_exists('e')) {
    function e(string $s): string
    {
        return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }
}

if (!function_exists('url')) {
    function url(string $path = '/'): string
    {
        $path = '/' . ltrim($path, '/');
        return base_path() . $path;
    }
}

if (!function_exists('url_path')) {
    function url_path(string $path = '/'): string
    {
        $path = '/' . ltrim($path, '/');
        return base_path() . $path;
    }
}
