<?php
declare(strict_types=1);

final class Seo
{
    public static function slugify(string $text): string
    {
        $text = trim($text);
        if ($text === '') return '';

        // transliteración básica
        $text = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $text) ?: $text;
        $text = strtolower($text);
        $text = preg_replace('/[^a-z0-9]+/', '-', $text) ?? '';
        $text = trim($text, '-');

        return $text;
    }
}
